/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.pool;

import java.util.ArrayDeque;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class SimplePool<ElementT> {
    private final ArrayDeque<ElementT> elements = new ArrayDeque();
    private final Supplier<ElementT> supplier;
    private final int maxCapacity;

    public SimplePool(Supplier<ElementT> supplier, int maxCapacity) {
        this.supplier = Objects.requireNonNull(supplier);
        this.maxCapacity = maxCapacity;
    }

    public ElementT get() {
        ElementT element = this.elements.pollFirst();
        if (element != null) {
            return element;
        }
        return this.supplier.get();
    }

    public void release(ElementT item) {
        if (this.elements.size() < this.maxCapacity) {
            this.elements.addFirst(item);
        }
    }
}

