/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.translation;

import org.apache.flink.statefun.sdk.io.EgressIdentifier;
import org.apache.flink.statefun.sdk.io.EgressSpec;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;

final class DecoratedSink {
    final String name;
    final String uid;
    final SinkFunction<?> sink;

    private DecoratedSink(String name, String uid, SinkFunction<?> sink) {
        this.name = name;
        this.uid = uid;
        this.sink = sink;
    }

    public static DecoratedSink of(EgressSpec<?> spec, SinkFunction<?> sink) {
        EgressIdentifier identifier = spec.id();
        String name = String.format("%s-%s-egress", identifier.namespace(), identifier.name());
        String uid = String.format("%s-%s-%s-%s-egress", spec.type().namespace(), spec.type().type(), identifier.namespace(), identifier.name());
        return new DecoratedSink(name, uid, sink);
    }
}

