/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator.perround;

import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.operator.OperatorUtils;
import org.apache.flink.iteration.operator.perround.AbstractPerRoundWrapperOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneInputPerRoundWrapperOperator<IN, OUT>
extends AbstractPerRoundWrapperOperator<OUT, OneInputStreamOperator<IN, OUT>>
implements OneInputStreamOperator<IterationRecord<IN>, IterationRecord<OUT>> {
    private static final Logger LOG = LoggerFactory.getLogger(OneInputPerRoundWrapperOperator.class);
    private final StreamRecord<IN> reusedInput = new StreamRecord(null, 0L);

    public OneInputPerRoundWrapperOperator(StreamOperatorParameters<IterationRecord<OUT>> parameters, StreamOperatorFactory<OUT> operatorFactory) {
        super(parameters, operatorFactory);
    }

    @Override
    protected void endInputAndEmitMaxWatermark(OneInputStreamOperator<IN, OUT> operator, int epoch, int epochWatermark) throws Exception {
        OperatorUtils.processOperatorOrUdfIfSatisfy(operator, BoundedOneInput.class, BoundedOneInput::endInput);
        operator.processWatermark(new Watermark(Long.MAX_VALUE));
    }

    public void processElement(StreamRecord<IterationRecord<IN>> element) throws Exception {
        switch (((IterationRecord)element.getValue()).getType()) {
            case RECORD: {
                this.reusedInput.replace(((IterationRecord)element.getValue()).getValue(), element.getTimestamp());
                this.setIterationContextRound(((IterationRecord)element.getValue()).getEpoch());
                ((OneInputStreamOperator)this.getWrappedOperator(((IterationRecord)element.getValue()).getEpoch())).processElement(this.reusedInput);
                this.clearIterationContextRound();
                break;
            }
            case EPOCH_WATERMARK: {
                this.onEpochWatermarkEvent(0, (IterationRecord)element.getValue());
                break;
            }
            default: {
                throw new FlinkRuntimeException("Not supported iteration record type: " + element);
            }
        }
    }

    public void processWatermark(Watermark mark) throws Exception {
        this.processForEachWrappedOperator((round, wrappedOperator) -> wrappedOperator.processWatermark(mark));
    }

    public void processWatermarkStatus(WatermarkStatus watermarkStatus) throws Exception {
        this.processForEachWrappedOperator((round, wrappedOperator) -> wrappedOperator.processWatermarkStatus(watermarkStatus));
    }

    public void processLatencyMarker(LatencyMarker latencyMarker) throws Exception {
        this.reportOrForwardLatencyMarker(latencyMarker);
    }
}

