/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.broadcast;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;

public class BroadcastStreamingRuntimeContext
extends StreamingRuntimeContext {
    Map<String, List<?>> broadcastVariables = new HashMap();

    public BroadcastStreamingRuntimeContext(Environment env, Map<String, Accumulator<?, ?>> accumulators, OperatorMetricGroup operatorMetricGroup, OperatorID operatorID, ProcessingTimeService processingTimeService, @Nullable KeyedStateStore keyedStateStore, ExternalResourceInfoProvider externalResourceInfoProvider) {
        super(env, accumulators, operatorMetricGroup, operatorID, processingTimeService, keyedStateStore, externalResourceInfoProvider);
    }

    public boolean hasBroadcastVariable(String name) {
        return this.broadcastVariables.containsKey(name);
    }

    public <RT> List<RT> getBroadcastVariable(String name) {
        if (this.broadcastVariables.containsKey(name)) {
            return this.broadcastVariables.get(name);
        }
        throw new RuntimeException("Cannot get broadcast variables before processing elements.");
    }

    public <T, C> C getBroadcastVariableWithInitializer(String name, BroadcastVariableInitializer<T, C> initializer) {
        if (this.broadcastVariables.containsKey(name)) {
            return (C)initializer.initializeBroadcastVariable(this.broadcastVariables.get(name));
        }
        throw new RuntimeException("Cannot get broadcast variables before processing elements.");
    }

    @Internal
    public void setBroadcastVariable(String name, List<?> broadcastVariable) {
        this.broadcastVariables.put(name, broadcastVariable);
    }
}

