/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.hashtable;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.operators.util.BloomFilter;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;

class HashTableBloomFilter {
    private final MemorySegment[] buffers;
    private final int numBuffers;
    private final int numBuffersMask;
    private final BloomFilter filter;
    private final int maxSize;
    private int size = 0;

    HashTableBloomFilter(MemorySegment[] buffers, long numRecords) {
        Preconditions.checkArgument(buffers != null && buffers.length > 0);
        this.buffers = buffers;
        this.numBuffers = buffers.length;
        Preconditions.checkArgument(MathUtils.isPowerOf2(this.numBuffers));
        this.numBuffersMask = this.numBuffers - 1;
        int bufferSize = buffers[0].size();
        this.filter = new BloomFilter((int)(numRecords / (long)this.numBuffers), buffers[0].size());
        this.filter.setBitsLocation(buffers[0], 0);
        this.maxSize = (int)((double)(this.numBuffers * bufferSize) * 2.44);
    }

    private void setLocation(int hash) {
        if (this.numBuffers > 1) {
            this.filter.setBitsLocation(this.buffers[hash & this.numBuffersMask], 0);
        }
    }

    boolean testHash(int hash) {
        this.setLocation(hash);
        return this.filter.testHash(hash);
    }

    boolean addHash(int hash) {
        this.setLocation(hash);
        this.filter.addHash(hash);
        ++this.size;
        return this.size <= this.maxSize;
    }

    public MemorySegment[] getBuffers() {
        return this.buffers;
    }

    static int optimalSegmentNumber(long maxNum, int segSize, double fpp) {
        double numBytes = (double)HashTableBloomFilter.optimalNumOfBits(maxNum, fpp) / 8.0;
        return (int)Math.ceil(numBytes / (double)segSize);
    }

    private static int optimalNumOfBits(long maxNumEntries, double fpp) {
        return (int)((double)(-maxNumEntries) * Math.log(fpp) / (Math.log(2.0) * Math.log(2.0)));
    }
}

