/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.TextElement;

public class HighAvailabilityOptions {
    @Documentation.Section(value={"common_high_availability"})
    public static final ConfigOption<String> HA_MODE = ConfigOptions.key("high-availability").stringType().defaultValue("NONE").withDeprecatedKeys("recovery.mode").withDescription("Defines high-availability mode used for the cluster execution. To enable high-availability, set this mode to \"ZOOKEEPER\" or specify FQN of factory class.");
    @Documentation.Section(value={"common_high_availability"})
    public static final ConfigOption<String> HA_CLUSTER_ID = ConfigOptions.key("high-availability.cluster-id").stringType().defaultValue("/default").withDeprecatedKeys("high-availability.zookeeper.path.namespace", "recovery.zookeeper.path.namespace").withDescription("The ID of the Flink cluster, used to separate multiple Flink clusters from each other. Needs to be set for standalone clusters but is automatically inferred in YARN.");
    @Documentation.Section(value={"common_high_availability"})
    public static final ConfigOption<String> HA_STORAGE_PATH = ConfigOptions.key("high-availability.storageDir").stringType().noDefaultValue().withDeprecatedKeys("high-availability.zookeeper.storageDir", "recovery.zookeeper.storageDir").withDescription("File system path (URI) where Flink persists metadata in high-availability setups.");
    @Documentation.Section(value={"expert_high_availability"})
    public static final ConfigOption<String> HA_JOB_MANAGER_PORT_RANGE = ConfigOptions.key("high-availability.jobmanager.port").stringType().defaultValue("0").withDeprecatedKeys("recovery.jobmanager.port").withDescription("The port (range) used by the Flink Master for its RPC connections in highly-available setups. In highly-available setups, this value is used instead of '" + JobManagerOptions.PORT.key() + "'.A value of '0' means that a random free port is chosen. TaskManagers discover this port through the high-availability services (leader election), so a random port or a port range works without requiring any additional means of service discovery.");
    @Documentation.Section(value={"common_high_availability_zk"})
    public static final ConfigOption<String> HA_ZOOKEEPER_QUORUM = ConfigOptions.key("high-availability.zookeeper.quorum").stringType().noDefaultValue().withDeprecatedKeys("recovery.zookeeper.quorum").withDescription("The ZooKeeper quorum to use, when running Flink in a high-availability mode with ZooKeeper.");
    @Documentation.Section(value={"common_high_availability_zk"})
    public static final ConfigOption<String> HA_ZOOKEEPER_ROOT = ConfigOptions.key("high-availability.zookeeper.path.root").stringType().defaultValue("/flink").withDeprecatedKeys("recovery.zookeeper.path.root").withDescription("The root path under which Flink stores its entries in ZooKeeper.");
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<String> HA_ZOOKEEPER_JOBGRAPHS_PATH = ConfigOptions.key("high-availability.zookeeper.path.jobgraphs").stringType().defaultValue("/jobgraphs").withDeprecatedKeys("recovery.zookeeper.path.jobgraphs").withDescription("ZooKeeper root path (ZNode) for job graphs");
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<Integer> ZOOKEEPER_SESSION_TIMEOUT = ConfigOptions.key("high-availability.zookeeper.client.session-timeout").intType().defaultValue(60000).withDeprecatedKeys("recovery.zookeeper.client.session-timeout").withDescription("Defines the session timeout for the ZooKeeper session in ms.");
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<Integer> ZOOKEEPER_CONNECTION_TIMEOUT = ConfigOptions.key("high-availability.zookeeper.client.connection-timeout").intType().defaultValue(15000).withDeprecatedKeys("recovery.zookeeper.client.connection-timeout").withDescription("Defines the connection timeout for ZooKeeper in ms.");
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<Integer> ZOOKEEPER_RETRY_WAIT = ConfigOptions.key("high-availability.zookeeper.client.retry-wait").intType().defaultValue(5000).withDeprecatedKeys("recovery.zookeeper.client.retry-wait").withDescription("Defines the pause between consecutive retries in ms.");
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<Integer> ZOOKEEPER_MAX_RETRY_ATTEMPTS = ConfigOptions.key("high-availability.zookeeper.client.max-retry-attempts").intType().defaultValue(3).withDeprecatedKeys("recovery.zookeeper.client.max-retry-attempts").withDescription("Defines the number of connection retries before the client gives up.");
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<String> ZOOKEEPER_RUNNING_JOB_REGISTRY_PATH = ConfigOptions.key("high-availability.zookeeper.path.running-registry").stringType().defaultValue("/running_job_registry/");
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<String> ZOOKEEPER_CLIENT_ACL = ConfigOptions.key("high-availability.zookeeper.client.acl").stringType().defaultValue("open").withDescription("Defines the ACL (open|creator) to be configured on ZK node. The configuration value can be set to \u201ccreator\u201d if the ZooKeeper server configuration has the \u201cauthProvider\u201d property mapped to use SASLAuthenticationProvider and the cluster is configured to run in secure mode (Kerberos).");
    @Documentation.Section(value={"expert_high_availability_zk"})
    public static final ConfigOption<Boolean> ZOOKEEPER_TOLERATE_SUSPENDED_CONNECTIONS = ConfigOptions.key("high-availability.zookeeper.client.tolerate-suspended-connections").booleanType().defaultValue(false).withDescription(Description.builder().text("Defines whether a suspended ZooKeeper connection will be treated as an error that causes the leader information to be invalidated or not. In case you set this option to %s, Flink will wait until a ZooKeeper connection is marked as lost before it revokes the leadership of components. This has the effect that Flink is more resilient against temporary connection instabilities at the cost of running more likely into timing issues with ZooKeeper.", TextElement.code("true")).build());
    @Deprecated
    public static final ConfigOption<String> HA_JOB_DELAY = ConfigOptions.key("high-availability.job.delay").stringType().noDefaultValue().withDeprecatedKeys("recovery.job.delay").withDescription("The time before a JobManager after a fail over recovers the current jobs.");
    @Documentation.Section(value={"expert_high_availability"})
    public static final ConfigOption<Boolean> USE_OLD_HA_SERVICES = ConfigOptions.key("high-availability.use-old-ha-services").booleanType().defaultValue(false).withDescription(Description.builder().text("Use this option to disable the new HA service implementations for ZooKeeper and K8s. This is a safety hatch in case that the new ha services are buggy.").build());

    private HighAvailabilityOptions() {
    }
}

