/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.util.Preconditions;

public class SecurityConfiguration {
    private final List<String> securityContextFactory;
    private final List<String> securityModuleFactories;
    private final Configuration flinkConfig;
    private final boolean isZkSaslDisable;
    private final boolean useTicketCache;
    private final String keytab;
    private final String principal;
    private final List<String> loginContextNames;
    private final String zkServiceName;
    private final String zkLoginContextName;

    public SecurityConfiguration(Configuration flinkConf) {
        this(flinkConf, flinkConf.get(SecurityOptions.SECURITY_CONTEXT_FACTORY_CLASSES), flinkConf.get(SecurityOptions.SECURITY_MODULE_FACTORY_CLASSES));
    }

    public SecurityConfiguration(Configuration flinkConf, List<String> securityContextFactory, List<String> securityModuleFactories) {
        this.isZkSaslDisable = flinkConf.getBoolean(SecurityOptions.ZOOKEEPER_SASL_DISABLE);
        this.keytab = flinkConf.getString(SecurityOptions.KERBEROS_LOGIN_KEYTAB);
        this.principal = flinkConf.getString(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL);
        this.useTicketCache = flinkConf.getBoolean(SecurityOptions.KERBEROS_LOGIN_USETICKETCACHE);
        this.loginContextNames = SecurityConfiguration.parseList(flinkConf.getString(SecurityOptions.KERBEROS_LOGIN_CONTEXTS));
        this.zkServiceName = flinkConf.getString(SecurityOptions.ZOOKEEPER_SASL_SERVICE_NAME);
        this.zkLoginContextName = flinkConf.getString(SecurityOptions.ZOOKEEPER_SASL_LOGIN_CONTEXT_NAME);
        this.securityModuleFactories = Collections.unmodifiableList(securityModuleFactories);
        this.securityContextFactory = securityContextFactory;
        this.flinkConfig = Preconditions.checkNotNull(flinkConf);
        this.validate();
    }

    public boolean isZkSaslDisable() {
        return this.isZkSaslDisable;
    }

    public String getKeytab() {
        return this.keytab;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public boolean useTicketCache() {
        return this.useTicketCache;
    }

    public Configuration getFlinkConfig() {
        return this.flinkConfig;
    }

    public List<String> getSecurityContextFactories() {
        return this.securityContextFactory;
    }

    public List<String> getSecurityModuleFactories() {
        return this.securityModuleFactories;
    }

    public List<String> getLoginContextNames() {
        return this.loginContextNames;
    }

    public String getZooKeeperServiceName() {
        return this.zkServiceName;
    }

    public String getZooKeeperLoginContextName() {
        return this.zkLoginContextName;
    }

    private void validate() {
        if (!StringUtils.isBlank((CharSequence)this.keytab)) {
            if (StringUtils.isBlank((CharSequence)this.principal)) {
                throw new IllegalConfigurationException("Kerberos login configuration is invalid: keytab requires a principal.");
            }
            File keytabFile = new File(this.keytab);
            if (!keytabFile.exists() || !keytabFile.isFile()) {
                throw new IllegalConfigurationException("Kerberos login configuration is invalid: keytab [" + this.keytab + "] doesn't exist!");
            }
            if (!keytabFile.canRead()) {
                throw new IllegalConfigurationException("Kerberos login configuration is invalid: keytab [" + this.keytab + "] is unreadable!");
            }
        }
    }

    private static List<String> parseList(String value) {
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(value.trim().replaceAll("(\\s*,+\\s*)+", ",").split(","));
    }
}

