/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.highavailability.JobResultEntry;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThreadsafeJobResultStore
implements JobResultStore {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractThreadsafeJobResultStore.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    @Override
    public void createDirtyResult(JobResultEntry jobResultEntry) throws IOException {
        Preconditions.checkState(!this.hasJobResultEntry(jobResultEntry.getJobId()), "Job result store already contains an entry for for job %s", jobResultEntry.getJobId());
        this.withWriteLock(() -> this.createDirtyResultInternal(jobResultEntry));
    }

    @GuardedBy(value="readWriteLock")
    protected abstract void createDirtyResultInternal(JobResultEntry var1) throws IOException;

    @Override
    public void markResultAsClean(JobID jobId) throws IOException, NoSuchElementException {
        if (this.hasCleanJobResultEntry(jobId)) {
            LOG.debug("The job {} is already marked as clean. No action required.", (Object)jobId);
            return;
        }
        this.withWriteLock(() -> this.markResultAsCleanInternal(jobId));
    }

    @GuardedBy(value="readWriteLock")
    protected abstract void markResultAsCleanInternal(JobID var1) throws IOException, NoSuchElementException;

    @Override
    public boolean hasJobResultEntry(JobID jobId) throws IOException {
        return this.withReadLock(() -> this.hasDirtyJobResultEntryInternal(jobId) || this.hasCleanJobResultEntryInternal(jobId));
    }

    @Override
    public boolean hasDirtyJobResultEntry(JobID jobId) throws IOException {
        return this.withReadLock(() -> this.hasDirtyJobResultEntryInternal(jobId));
    }

    @GuardedBy(value="readWriteLock")
    protected abstract boolean hasDirtyJobResultEntryInternal(JobID var1) throws IOException;

    @Override
    public boolean hasCleanJobResultEntry(JobID jobId) throws IOException {
        return this.withReadLock(() -> this.hasCleanJobResultEntryInternal(jobId));
    }

    @GuardedBy(value="readWriteLock")
    protected abstract boolean hasCleanJobResultEntryInternal(JobID var1) throws IOException;

    @Override
    public Set<JobResult> getDirtyResults() throws IOException {
        return this.withReadLock(this::getDirtyResultsInternal);
    }

    @GuardedBy(value="readWriteLock")
    protected abstract Set<JobResult> getDirtyResultsInternal() throws IOException;

    private void withWriteLock(ThrowingRunnable<IOException> runnable) throws IOException {
        this.readWriteLock.writeLock().lock();
        try {
            runnable.run();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private <T> T withReadLock(SupplierWithException<T, IOException> runnable) throws IOException {
        this.readWriteLock.readLock().lock();
        try {
            T t = runnable.get();
            return t;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

