/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact.aggregate;

import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.store.file.mergetree.compact.aggregate.FieldAggregator;
import org.apache.flink.table.types.logical.LogicalType;

public class FieldSumAgg
extends FieldAggregator {
    public FieldSumAgg(LogicalType logicalType) {
        super(logicalType);
    }

    @Override
    Object agg(Object accumulator, Object inputField) {
        Object sum;
        if (accumulator == null || inputField == null) {
            sum = accumulator == null ? inputField : accumulator;
        } else {
            switch (this.fieldType.getTypeRoot()) {
                case DECIMAL: {
                    DecimalData mergeFieldDD = (DecimalData)accumulator;
                    DecimalData inFieldDD = (DecimalData)inputField;
                    assert (mergeFieldDD.scale() == inFieldDD.scale()) : "Inconsistent scale of aggregate DecimalData!";
                    assert (mergeFieldDD.precision() == inFieldDD.precision()) : "Inconsistent precision of aggregate DecimalData!";
                    sum = DecimalDataUtils.add(mergeFieldDD, inFieldDD, mergeFieldDD.precision(), mergeFieldDD.scale());
                    break;
                }
                case TINYINT: {
                    sum = (byte)((Byte)accumulator + (Byte)inputField);
                    break;
                }
                case SMALLINT: {
                    sum = (short)((Short)accumulator + (Short)inputField);
                    break;
                }
                case INTEGER: {
                    sum = (Integer)accumulator + (Integer)inputField;
                    break;
                }
                case BIGINT: {
                    sum = (Long)accumulator + (Long)inputField;
                    break;
                }
                case FLOAT: {
                    sum = Float.valueOf(((Float)accumulator).floatValue() + ((Float)inputField).floatValue());
                    break;
                }
                case DOUBLE: {
                    sum = (Double)accumulator + (Double)inputField;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return sum;
    }
}

