/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.IOException;
import org.apache.geode.Instantiator;
import org.apache.geode.SerializationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.cache.ClientServerObserver;
import org.apache.geode.internal.cache.ClientServerObserverHolder;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.util.BlobHelper;

public class RegisterInstantiatorsOp {
    public static void execute(ExecutablePool pool, Instantiator[] instantiators, EventID eventId) {
        RegisterInstantiatorsOpImpl op = new RegisterInstantiatorsOpImpl(instantiators, eventId);
        pool.execute(op, Integer.MAX_VALUE);
    }

    public static void execute(ExecutablePool pool, Object[] holders, EventID eventId) {
        RegisterInstantiatorsOpImpl op = new RegisterInstantiatorsOpImpl(holders, eventId);
        pool.execute(op, Integer.MAX_VALUE);
    }

    private RegisterInstantiatorsOp() {
    }

    private static class RegisterInstantiatorsOpImpl
    extends AbstractOp {
        public RegisterInstantiatorsOpImpl(Instantiator[] instantiators, EventID eventId) {
            super(51, instantiators.length * 3 + 1);
            for (int i = 0; i < instantiators.length; ++i) {
                Instantiator instantiator = instantiators[i];
                String className = instantiator.getClass().toString().substring(6);
                String instantiatedClassName = instantiator.getInstantiatedClass().toString().substring(6);
                try {
                    this.getMessage().addBytesPart(BlobHelper.serializeToBlob(className));
                    this.getMessage().addBytesPart(BlobHelper.serializeToBlob(instantiatedClassName));
                }
                catch (IOException ex) {
                    throw new SerializationException("failed serializing object", ex);
                }
                this.getMessage().addIntPart(instantiator.getId());
            }
            this.getMessage().addBytesPart(eventId.calcBytes());
            if (PoolImpl.IS_INSTANTIATOR_CALLBACK) {
                ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                bo.beforeSendingToServer(eventId);
            }
        }

        public RegisterInstantiatorsOpImpl(Object[] holders, EventID eventId) {
            super(51, holders.length * 3 + 1);
            for (Object obj : holders) {
                String instantiatorClassName = null;
                String instantiatedClassName = null;
                int id = 0;
                if (obj instanceof Instantiator) {
                    instantiatorClassName = ((Instantiator)obj).getClass().getName();
                    instantiatedClassName = ((Instantiator)obj).getInstantiatedClass().getName();
                    id = ((Instantiator)obj).getId();
                } else {
                    instantiatorClassName = ((InternalInstantiator.InstantiatorAttributesHolder)obj).getInstantiatorClassName();
                    instantiatedClassName = ((InternalInstantiator.InstantiatorAttributesHolder)obj).getInstantiatedClassName();
                    id = ((InternalInstantiator.InstantiatorAttributesHolder)obj).getId();
                }
                try {
                    this.getMessage().addBytesPart(BlobHelper.serializeToBlob(instantiatorClassName));
                    this.getMessage().addBytesPart(BlobHelper.serializeToBlob(instantiatedClassName));
                }
                catch (IOException ex) {
                    throw new SerializationException("failed serializing object", ex);
                }
                this.getMessage().addIntPart(id);
            }
            this.getMessage().addBytesPart(eventId.calcBytes());
            if (PoolImpl.IS_INSTANTIATOR_CALLBACK) {
                ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                bo.beforeSendingToServer(eventId);
            }
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "registerInstantiators");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startRegisterInstantiators();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endRegisterInstantiatorsSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endRegisterInstantiators(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

