/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.DefaultResultCollector;
import org.apache.geode.internal.cache.execute.InternalExecution;
import org.apache.geode.internal.cache.execute.LocalResultCollector;
import org.apache.geode.internal.cache.execute.MemberFunctionResultSender;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.MultiRegionFunctionContextImpl;
import org.apache.geode.internal.cache.execute.MultiRegionFunctionResultWaiter;
import org.apache.geode.internal.cache.execute.NoResult;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;

public class MultiRegionFunctionExecutor
extends AbstractExecution {
    private final Set<Region> regions;
    private ServerToClientFunctionResultSender sender;

    public MultiRegionFunctionExecutor(Set<Region> regions) {
        this.regions = regions;
    }

    private MultiRegionFunctionExecutor(MultiRegionFunctionExecutor drfe) {
        super(drfe);
        this.regions = drfe.regions;
        if (drfe.filter != null) {
            this.filter.clear();
            this.filter.addAll(drfe.filter);
        }
        this.sender = drfe.sender;
    }

    private MultiRegionFunctionExecutor(Set<Region> regions, Set filter2, Object args, MemberMappedArgument memberMappedArg, ServerToClientFunctionResultSender resultSender) {
        if (args != null) {
            this.args = args;
        } else if (memberMappedArg != null) {
            this.memberMappedArg = memberMappedArg;
            this.isMemberMappedArgument = true;
        }
        this.sender = resultSender;
        if (filter2 != null) {
            this.filter.clear();
            this.filter.addAll(filter2);
        }
        this.regions = regions;
        this.isClientServerMode = true;
    }

    private MultiRegionFunctionExecutor(MultiRegionFunctionExecutor executor, MemberMappedArgument argument) {
        super(executor);
        this.regions = executor.getRegions();
        this.filter.clear();
        this.filter.addAll(executor.filter);
        this.sender = executor.getServerResultSender();
        this.memberMappedArg = argument;
        this.isMemberMappedArgument = true;
    }

    private MultiRegionFunctionExecutor(MultiRegionFunctionExecutor executor, ResultCollector rs) {
        super(executor);
        this.regions = executor.getRegions();
        this.filter.clear();
        this.filter.addAll(executor.filter);
        this.sender = executor.getServerResultSender();
        this.rc = rs;
    }

    public MultiRegionFunctionExecutor(MultiRegionFunctionExecutor executor, Object args) {
        super(executor);
        this.regions = executor.getRegions();
        this.filter.clear();
        this.filter.addAll(executor.filter);
        this.sender = executor.getServerResultSender();
        this.args = args;
    }

    public MultiRegionFunctionExecutor(MultiRegionFunctionExecutor executor, boolean isReExecute) {
        super(executor);
        this.regions = executor.getRegions();
        this.filter.clear();
        this.filter.addAll(executor.filter);
        this.sender = executor.getServerResultSender();
        this.isReExecute = isReExecute;
    }

    @Override
    public InternalExecution withMemberMappedArgument(MemberMappedArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("The input %s for the execute function request is null", "MemberMapped Arg"));
        }
        return new MultiRegionFunctionExecutor(this, argument);
    }

    public Set<Region> getRegions() {
        return this.regions;
    }

    public ServerToClientFunctionResultSender getServerResultSender() {
        return this.sender;
    }

    public Execution setArguments(Object args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("The input %s for the execute function request is null", "args"));
        }
        return new MultiRegionFunctionExecutor(this, args);
    }

    public Execution withArgs(Object args) {
        return this.setArguments(args);
    }

    public Execution withCollector(ResultCollector rc) {
        if (rc == null) {
            throw new IllegalArgumentException(String.format("The input %s for the execute function request is null", "Result Collector"));
        }
        return new MultiRegionFunctionExecutor(this, rc);
    }

    public Execution withFilter(Set filter) {
        throw new FunctionException(String.format("Cannot specify %s for multi region function", "filter"));
    }

    @Override
    public InternalExecution withBucketFilter(Set<Integer> bucketIDs) {
        throw new FunctionException(String.format("Cannot specify %s for multi region function", "bucket as filter"));
    }

    @Override
    protected ResultCollector executeFunction(Function function, long timeout, TimeUnit unit) {
        if (!function.hasResult()) {
            this.executeFunction(function, null);
            return new NoResult();
        }
        ResultCollector inRc = this.rc == null ? new DefaultResultCollector() : this.rc;
        ResultCollector rcToReturn = this.executeFunction(function, inRc);
        if (timeout > 0L) {
            try {
                rcToReturn.getResult(timeout, unit);
            }
            catch (Exception e) {
                throw new FunctionException(e);
            }
        }
        return rcToReturn;
    }

    private ResultCollector executeFunction(Function function, ResultCollector resultCollector) {
        InternalDistributedSystem ds = InternalDistributedSystem.getConnectedInstance();
        if (ds == null) {
            throw new IllegalStateException("DistributedSystem is either not created or not ready");
        }
        DistributionManager dm = ds.getDistributionManager();
        Map<InternalDistributedMember, Set<String>> memberToRegionMap = this.calculateMemberToRegionMap();
        HashSet<InternalDistributedMember> dest = new HashSet<InternalDistributedMember>(memberToRegionMap.keySet());
        if (dest.isEmpty()) {
            throw new FunctionException(String.format("No member found for executing function : %s.", function.getId()));
        }
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null) {
            cache.getInternalResourceManager().getHeapMonitor().checkForLowMemory(function, Collections.unmodifiableSet(dest));
        }
        this.setExecutionNodes(dest);
        InternalDistributedMember localVM = cache.getMyId();
        LocalResultCollector<?, ?> localResultCollector = this.getLocalResultCollector(function, resultCollector);
        boolean remoteOnly = false;
        boolean localOnly = false;
        if (!dest.contains(localVM)) {
            remoteOnly = true;
        }
        if (dest.size() == 1 && dest.contains(localVM)) {
            localOnly = true;
        }
        this.validateExecution(function, dest);
        MemberFunctionResultSender resultSender = new MemberFunctionResultSender(dm, localResultCollector, function, localOnly, remoteOnly, null);
        if (dest.contains(localVM)) {
            dest.remove(localVM);
            Set<String> regionPathSet = memberToRegionMap.get(localVM);
            HashSet regions = new HashSet();
            if (regionPathSet != null) {
                GemFireCacheImpl cache1 = GemFireCacheImpl.getInstance();
                for (String regionPath : regionPathSet) {
                    regions.add(cache1.getRegion(regionPath));
                }
            }
            MultiRegionFunctionContextImpl context = new MultiRegionFunctionContextImpl(cache, function.getId(), this.getArgumentsForMember(localVM.getId()), resultSender, regions, this.isReExecute);
            boolean isTx = cache.getTxManager().getTXState() != null;
            this.executeFunctionOnLocalNode(function, context, resultSender, dm, isTx);
        }
        if (!dest.isEmpty()) {
            HashMap<InternalDistributedMember, Object> memberArgs = new HashMap<InternalDistributedMember, Object>();
            for (InternalDistributedMember recip : dest) {
                memberArgs.put(recip, this.getArgumentsForMember(recip.getId()));
            }
            Assert.assertTrue(memberArgs.size() == dest.size());
            MultiRegionFunctionResultWaiter waiter = new MultiRegionFunctionResultWaiter(ds, localResultCollector, function, dest, memberArgs, resultSender, memberToRegionMap);
            return waiter.getFunctionResultFrom(dest, function, this);
        }
        return localResultCollector;
    }

    private Map<InternalDistributedMember, Set<String>> calculateMemberToRegionMap() {
        HashMap<InternalDistributedMember, Set<String>> memberToRegions = new HashMap<InternalDistributedMember, Set<String>>();
        HashSet nodes = new HashSet();
        for (Region region : this.regions) {
            InternalDistributedMember local;
            InternalCache cache;
            Set<String> regions;
            DataPolicy dp = region.getAttributes().getDataPolicy();
            if (region instanceof PartitionedRegion) {
                PartitionedRegion pr = (PartitionedRegion)region;
                Set prMembers = pr.getRegionAdvisor().advisePrimaryOwners();
                if (pr.isDataStore()) {
                    InternalCache cache2 = (InternalCache)region.getCache();
                    InternalDistributedMember localVm = cache2.getMyId();
                    regions = (HashSet<String>)memberToRegions.get(localVm);
                    if (regions == null) {
                        regions = new HashSet<String>();
                    }
                    regions.add(pr.getFullPath());
                    memberToRegions.put(localVm, regions);
                }
                if (prMembers == null) continue;
                for (Object member : prMembers) {
                    regions = (Set)memberToRegions.get(member);
                    if (regions == null) {
                        regions = new HashSet();
                    }
                    regions.add(pr.getFullPath());
                    memberToRegions.put((InternalDistributedMember)member, regions);
                }
                nodes.addAll(prMembers);
                continue;
            }
            if (region instanceof DistributedRegion) {
                if (dp.isEmpty() || dp.isNormal()) {
                    Object member;
                    DistributedRegion dr = (DistributedRegion)region;
                    Set<InternalDistributedMember> replicates = dr.getCacheDistributionAdvisor().adviseInitializedReplicates();
                    boolean added = false;
                    member = replicates.iterator();
                    while (member.hasNext()) {
                        InternalDistributedMember member2 = (InternalDistributedMember)member.next();
                        if (!nodes.contains(member2)) continue;
                        added = true;
                        HashSet<String> regions2 = (HashSet<String>)memberToRegions.get(member2);
                        if (regions2 == null) {
                            regions2 = new HashSet<String>();
                        }
                        regions2.add(dr.getFullPath());
                        memberToRegions.put(member2, regions2);
                        break;
                    }
                    if (replicates.size() == 0 || added) continue;
                    member = (InternalDistributedMember)replicates.toArray()[new Random().nextInt(replicates.size())];
                    regions = (Set)memberToRegions.get(member);
                    if (regions == null) {
                        regions = new HashSet();
                    }
                    regions.add(dr.getFullPath());
                    memberToRegions.put((InternalDistributedMember)member, regions);
                    continue;
                }
                if (!dp.withReplication()) continue;
                cache = (InternalCache)region.getCache();
                local = cache.getMyId();
                HashSet<String> regions3 = (HashSet<String>)memberToRegions.get(local);
                if (regions3 == null) {
                    regions3 = new HashSet<String>();
                }
                regions3.add(region.getFullPath());
                memberToRegions.put(local, regions3);
                continue;
            }
            if (!(region instanceof LocalRegion)) continue;
            cache = (InternalCache)region.getCache();
            local = cache.getMyId();
            HashSet<String> regions4 = (HashSet<String>)memberToRegions.get(local);
            if (regions4 == null) {
                regions4 = new HashSet<String>();
            }
            regions4.add(region.getFullPath());
            memberToRegions.put(local, regions4);
        }
        return memberToRegions;
    }

    @Override
    public AbstractExecution setIsReExecute() {
        return new MultiRegionFunctionExecutor(this, true);
    }

    public void validateExecution(Function function, Set targetMembers) {
        InternalCache cache = null;
        Iterator<Region> iterator = this.regions.iterator();
        if (iterator.hasNext()) {
            Region r = iterator.next();
            cache = (InternalCache)r.getCache();
        }
        if (cache == null) {
            return;
        }
        if (cache.getTxManager().getTXState() != null) {
            if (targetMembers.size() > 1) {
                throw new TransactionException("Function inside a transaction cannot execute on more than one node");
            }
            assert (targetMembers.size() == 1);
            DistributedMember funcTarget = (DistributedMember)targetMembers.iterator().next();
            DistributedMember target = cache.getTxManager().getTXState().getTarget();
            if (target == null) {
                cache.getTxManager().getTXState().setTarget(funcTarget);
            } else if (!target.equals(funcTarget)) {
                throw new TransactionDataNotColocatedException(String.format("Function execution is not colocated with transaction. The transactional data is hosted on node %s, but you are trying to target node %s", target, funcTarget));
            }
        }
        cache.getInternalResourceManager().getHeapMonitor().checkForLowMemory(function, targetMembers);
    }
}

