/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.fork;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.reactivex.Flowable;
import io.reactivex.functions.Predicate;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.fork.CopyHelper;
import org.apache.gobblin.fork.CopyNotSupportedException;
import org.apache.gobblin.fork.ForkOperator;
import org.apache.gobblin.metadata.GlobalMetadata;
import org.apache.gobblin.records.RecordStreamWithMetadata;
import org.apache.gobblin.stream.ControlMessage;
import org.apache.gobblin.stream.RecordEnvelope;
import org.apache.gobblin.stream.StreamEntity;

public class Forker {
    public <D, S> ForkedStream<D, S> forkStream(RecordStreamWithMetadata<D, S> inputStream, ForkOperator<S, D> forkOperator, WorkUnitState workUnitState) throws Exception {
        int branches = forkOperator.getBranches(workUnitState);
        workUnitState.setProp("fork.branches", branches);
        forkOperator.init(workUnitState);
        List<Boolean> forkedSchemas = forkOperator.forkSchema(workUnitState, inputStream.getGlobalMetadata().getSchema());
        int activeForks = (int)forkedSchemas.stream().filter(b -> b).count();
        Preconditions.checkState((forkedSchemas.size() == branches ? 1 : 0) != 0, (Object)String.format("Number of forked schemas [%d] is not equal to number of branches [%d]", forkedSchemas.size(), branches));
        Flowable forkedStream = inputStream.getRecordStream().map(r -> {
            if (r instanceof RecordEnvelope) {
                RecordEnvelope recordEnvelope = (RecordEnvelope)r;
                return new RecordWithForkMap(recordEnvelope, forkOperator.forkDataRecord(workUnitState, recordEnvelope.getRecord()));
            }
            if (r instanceof ControlMessage) {
                return new RecordWithForkMap((ControlMessage)r, branches);
            }
            throw new IllegalStateException("Expected RecordEnvelope or ControlMessage.");
        });
        if (activeForks > 1) {
            forkedStream = forkedStream.share();
        }
        ArrayList forkStreams = Lists.newArrayList();
        boolean mustCopy = Forker.mustCopy(forkedSchemas);
        for (int i = 0; i < forkedSchemas.size(); ++i) {
            if (forkedSchemas.get(i).booleanValue()) {
                int idx = i;
                Flowable thisStream = forkedStream.filter(new ForkFilter(idx)).map(rec$ -> ((RecordWithForkMap)rec$).getRecordCopyIfNecessary());
                forkStreams.add(inputStream.withRecordStream(thisStream, mustCopy ? (GlobalMetadata)CopyHelper.copy(inputStream.getGlobalMetadata()) : inputStream.getGlobalMetadata()));
                continue;
            }
            forkStreams.add(null);
        }
        return new ForkedStream(forkStreams);
    }

    private static boolean mustCopy(List<Boolean> forkMap) {
        return forkMap.stream().filter(b -> b).count() >= 2L;
    }

    private static class RecordWithForkMap<D> {
        private final StreamEntity<D> record;
        private final List<Boolean> forkMap;
        private final boolean mustCopy;
        private final StreamEntity.ForkCloner cloner;
        private long copiesLeft;

        public RecordWithForkMap(RecordEnvelope<D> record, List<Boolean> forkMap) {
            this.record = record;
            this.forkMap = Lists.newArrayList(forkMap);
            this.mustCopy = Forker.mustCopy(forkMap);
            this.copiesLeft = this.forkMap.stream().filter(x -> x).count();
            this.cloner = this.buildForkCloner();
        }

        public RecordWithForkMap(ControlMessage<D> record, int activeBranchesForRecord) {
            this.record = record;
            this.forkMap = null;
            this.copiesLeft = activeBranchesForRecord;
            this.mustCopy = this.copiesLeft > 1L;
            this.cloner = this.buildForkCloner();
        }

        private StreamEntity.ForkCloner buildForkCloner() {
            if (this.mustCopy) {
                return this.record.forkCloner();
            }
            return null;
        }

        private synchronized StreamEntity<D> getRecordCopyIfNecessary() throws CopyNotSupportedException {
            if (this.mustCopy) {
                StreamEntity clone = this.cloner.getClone();
                --this.copiesLeft;
                if (this.copiesLeft <= 0L) {
                    this.cloner.close();
                }
                return clone;
            }
            return this.record;
        }

        public boolean sendToBranch(int idx) {
            if (this.record instanceof RecordEnvelope) {
                return this.forkMap.get(idx);
            }
            return true;
        }
    }

    private static class ForkFilter<D>
    implements Predicate<RecordWithForkMap<D>> {
        private final int forkIdx;

        public boolean test(RecordWithForkMap<D> dRecordWithForkMap) {
            return dRecordWithForkMap.sendToBranch(this.forkIdx);
        }

        @ConstructorProperties(value={"forkIdx"})
        public ForkFilter(int forkIdx) {
            this.forkIdx = forkIdx;
        }

        public int getForkIdx() {
            return this.forkIdx;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForkFilter)) {
                return false;
            }
            ForkFilter other = (ForkFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getForkIdx() == other.getForkIdx();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForkFilter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getForkIdx();
            return result;
        }

        public String toString() {
            return "Forker.ForkFilter(forkIdx=" + this.getForkIdx() + ")";
        }
    }

    public static class ForkedStream<D, S> {
        private final List<RecordStreamWithMetadata<D, S>> forkedStreams;

        @ConstructorProperties(value={"forkedStreams"})
        public ForkedStream(List<RecordStreamWithMetadata<D, S>> forkedStreams) {
            this.forkedStreams = forkedStreams;
        }

        public List<RecordStreamWithMetadata<D, S>> getForkedStreams() {
            return this.forkedStreams;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForkedStream)) {
                return false;
            }
            ForkedStream other = (ForkedStream)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<RecordStreamWithMetadata<D, S>> this$forkedStreams = this.getForkedStreams();
            List<RecordStreamWithMetadata<D, S>> other$forkedStreams = other.getForkedStreams();
            return !(this$forkedStreams == null ? other$forkedStreams != null : !((Object)this$forkedStreams).equals(other$forkedStreams));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForkedStream;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<RecordStreamWithMetadata<D, S>> $forkedStreams = this.getForkedStreams();
            result = result * 59 + ($forkedStreams == null ? 43 : ((Object)$forkedStreams).hashCode());
            return result;
        }

        public String toString() {
            return "Forker.ForkedStream(forkedStreams=" + this.getForkedStreams() + ")";
        }
    }
}

