/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Stat;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.stats.StatsCollectionTaskIndependent;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.JobConf;

public class TableScanOperator
extends Operator<TableScanDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient JobConf jc;
    private transient Configuration hconf;
    private transient boolean inputFileChanged = false;
    private TableDesc tableDesc;
    private transient Stat currentStat;
    private transient Map<String, Stat> stats;
    private transient int rowLimit = -1;
    private transient int currCount = 0;
    private String defaultPartitionName;

    public TableDesc getTableDesc() {
        return this.tableDesc;
    }

    public void setTableDesc(TableDesc tableDesc) {
        this.tableDesc = tableDesc;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (this.rowLimit >= 0 && this.currCount++ >= this.rowLimit) {
            this.setDone(true);
            return;
        }
        if (this.conf != null && ((TableScanDesc)this.conf).isGatherStats()) {
            this.gatherStats(row);
        }
        this.forward(row, this.inputObjInspectors[tag]);
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        Map<String, Integer> bucketNameMapping;
        this.inputFileChanged = true;
        Map<String, Integer> map = bucketNameMapping = this.conf != null ? ((TableScanDesc)this.conf).getBucketFileNameMapping() : null;
        if (bucketNameMapping != null && !bucketNameMapping.isEmpty()) {
            Path currentInputPath = this.getExecContext().getCurrentInputPath();
            this.getExecContext().setFileId(Integer.toString(bucketNameMapping.get(currentInputPath.getName())));
        }
    }

    private void gatherStats(Object row) {
        if (this.currentStat == null || this.inputFileChanged) {
            String partitionSpecs;
            this.inputFileChanged = false;
            if (((TableScanDesc)this.conf).getPartColumns() == null || ((TableScanDesc)this.conf).getPartColumns().size() == 0) {
                partitionSpecs = "";
            } else {
                assert (this.inputObjInspectors[0].getCategory() == ObjectInspector.Category.STRUCT) : "input object inspector is not struct";
                ArrayList writable = new ArrayList(((TableScanDesc)this.conf).getPartColumns().size());
                ArrayList<String> values = new ArrayList<String>(((TableScanDesc)this.conf).getPartColumns().size());
                int dpStartCol = 0;
                StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[0];
                for (StructField sf : soi.getAllStructFieldRefs()) {
                    String fn = sf.getFieldName();
                    if (((TableScanDesc)this.conf).getPartColumns().contains(fn)) break;
                    ++dpStartCol;
                }
                ObjectInspectorUtils.partialCopyToStandardObject(writable, (Object)row, (int)dpStartCol, (int)((TableScanDesc)this.conf).getPartColumns().size(), (StructObjectInspector)((StructObjectInspector)this.inputObjInspectors[0]), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                for (Object o : writable) {
                    values.add(o == null ? this.defaultPartitionName : o.toString());
                }
                partitionSpecs = FileUtils.makePartName(((TableScanDesc)this.conf).getPartColumns(), values);
                this.LOG.info((Object)("Stats Gathering found a new partition spec = " + partitionSpecs));
            }
            int uSizeColumn = -1;
            StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[0];
            for (int i = 0; i < soi.getAllStructFieldRefs().size(); ++i) {
                if (!((StructField)soi.getAllStructFieldRefs().get(i)).getFieldName().equals(VirtualColumn.RAWDATASIZE.getName().toLowerCase())) continue;
                uSizeColumn = i;
                break;
            }
            this.currentStat = this.stats.get(partitionSpecs);
            if (this.currentStat == null) {
                this.currentStat = new Stat();
                this.currentStat.setBookkeepingInfo("rawDataSize", uSizeColumn);
                this.stats.put(partitionSpecs, this.currentStat);
            }
        }
        this.currentStat.addToStat("numRows", 1L);
        int rdSizeColumn = this.currentStat.getBookkeepingInfo("rawDataSize");
        if (rdSizeColumn != -1) {
            ArrayList rdSize = new ArrayList(1);
            ObjectInspectorUtils.partialCopyToStandardObject(rdSize, (Object)row, (int)rdSizeColumn, (int)1, (StructObjectInspector)((StructObjectInspector)this.inputObjInspectors[0]), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            this.currentStat.addToStat("rawDataSize", ((LongWritable)rdSize.get(0)).get());
        }
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        this.initializeChildren(hconf);
        this.inputFileChanged = false;
        if (this.conf == null) {
            return;
        }
        this.rowLimit = ((TableScanDesc)this.conf).getRowLimit();
        if (!((TableScanDesc)this.conf).isGatherStats()) {
            return;
        }
        this.hconf = hconf;
        this.jc = hconf instanceof JobConf ? (JobConf)hconf : new JobConf(hconf);
        this.defaultPartitionName = HiveConf.getVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        this.currentStat = null;
        this.stats = new HashMap<String, Stat>();
        if (((TableScanDesc)this.conf).getPartColumns() == null || ((TableScanDesc)this.conf).getPartColumns().size() == 0) {
            return;
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.conf != null && ((TableScanDesc)this.conf).isGatherStats() && this.stats.size() != 0) {
            this.publishStats();
        }
    }

    @Override
    public String getName() {
        return TableScanOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "TS";
    }

    public void setNeededColumnIDs(List<Integer> orign_columns) {
        ((TableScanDesc)this.conf).setNeededColumnIDs(orign_columns);
    }

    public List<Integer> getNeededColumnIDs() {
        return ((TableScanDesc)this.conf).getNeededColumnIDs();
    }

    public void setNeededColumns(List<String> columnNames) {
        ((TableScanDesc)this.conf).setNeededColumns(columnNames);
    }

    public List<String> getNeededColumns() {
        return ((TableScanDesc)this.conf).getNeededColumns();
    }

    public void setReferencedColumns(List<String> referencedColumns) {
        ((TableScanDesc)this.conf).setReferencedColumns(referencedColumns);
    }

    public List<String> getReferencedColumns() {
        return ((TableScanDesc)this.conf).getReferencedColumns();
    }

    @Override
    public OperatorType getType() {
        return OperatorType.TABLESCAN;
    }

    private void publishStats() throws HiveException {
        boolean isStatsReliable = ((TableScanDesc)this.conf).isStatsReliable();
        StatsPublisher statsPublisher = Utilities.getStatsPublisher(this.jc);
        if (!statsPublisher.connect((Configuration)this.jc)) {
            this.LOG.info((Object)"StatsPublishing error: cannot connect to database.");
            if (isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_CONNECTION_ERROR.getErrorCodedMsg());
            }
            return;
        }
        String taskID = Utilities.getTaskIdFromFilename(Utilities.getTaskId(this.hconf));
        HashMap<String, String> statsToPublish = new HashMap<String, String>();
        for (String pspecs : this.stats.keySet()) {
            statsToPublish.clear();
            String prefix = Utilities.join(((TableScanDesc)this.conf).getStatsAggPrefix(), pspecs);
            int maxKeyLength = ((TableScanDesc)this.conf).getMaxStatsKeyPrefixLength();
            String key = Utilities.getHashedStatsPrefix(prefix, maxKeyLength);
            if (!(statsPublisher instanceof StatsCollectionTaskIndependent)) {
                key = Utilities.join(prefix, taskID);
            }
            for (String statType : this.stats.get(pspecs).getStoredStats()) {
                statsToPublish.put(statType, Long.toString(this.stats.get(pspecs).getStat(statType)));
            }
            if (!statsPublisher.publishStat(key, statsToPublish) && isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_PUBLISHING_ERROR.getErrorCodedMsg());
            }
            this.LOG.info((Object)("publishing : " + key + " : " + ((Object)statsToPublish).toString()));
        }
        if (!statsPublisher.closeConnection() && isStatsReliable) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_CLOSING_ERROR.getErrorCodedMsg());
        }
    }

    @Override
    public boolean supportSkewJoinOptimization() {
        return true;
    }

    @Override
    public boolean supportAutomaticSortMergeJoin() {
        return true;
    }

    @Override
    public Operator<? extends OperatorDesc> clone() throws CloneNotSupportedException {
        TableScanOperator ts = (TableScanOperator)super.clone();
        ts.setNeededColumnIDs(new ArrayList<Integer>(this.getNeededColumnIDs()));
        ts.setNeededColumns(new ArrayList<String>(this.getNeededColumns()));
        ts.setReferencedColumns(new ArrayList<String>(this.getReferencedColumns()));
        return ts;
    }
}

