/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tez.runtime.api.ObjectRegistry;

public class ObjectCache
implements org.apache.hadoop.hive.ql.exec.ObjectCache {
    private static final Log LOG = LogFactory.getLog((String)ObjectCache.class.getName());
    private static volatile ObjectRegistry staticRegistry;
    private final ObjectRegistry registry;

    public ObjectCache() {
        Preconditions.checkNotNull((Object)staticRegistry, (Object)"Object registry not setup yet. This should have been setup by the TezProcessor");
        this.registry = staticRegistry;
    }

    public static void setupObjectRegistry(ObjectRegistry objectRegistry) {
        staticRegistry = objectRegistry;
    }

    @Override
    public void cache(String key, Object value) {
        LOG.info((Object)("Adding " + key + " to cache with value " + value));
        this.registry.cacheForVertex(key, value);
    }

    @Override
    public Object retrieve(String key) {
        Object o = this.registry.get(key);
        if (o != null) {
            LOG.info((Object)("Found " + key + " in cache with value: " + o));
        }
        return o;
    }
}

