/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class VectorColumnSetInfo {
    protected int[] longIndices;
    protected int[] doubleIndices;
    protected int[] stringIndices;
    protected int[] decimalIndices;
    protected KeyLookupHelper[] indexLookup;
    private int keyCount;
    private int addIndex;
    protected int longIndicesIndex;
    protected int doubleIndicesIndex;
    protected int stringIndicesIndex;
    protected int decimalIndicesIndex;

    protected VectorColumnSetInfo(int keyCount) {
        this.keyCount = keyCount;
        this.addIndex = 0;
        this.longIndices = new int[this.keyCount];
        this.longIndicesIndex = 0;
        this.doubleIndices = new int[this.keyCount];
        this.doubleIndicesIndex = 0;
        this.stringIndices = new int[this.keyCount];
        this.stringIndicesIndex = 0;
        this.decimalIndices = new int[this.keyCount];
        this.decimalIndicesIndex = 0;
        this.indexLookup = new KeyLookupHelper[this.keyCount];
    }

    protected void addKey(String outputType) throws HiveException {
        this.indexLookup[this.addIndex] = new KeyLookupHelper();
        if (VectorizationContext.isIntFamily(outputType) || VectorizationContext.isDatetimeFamily(outputType)) {
            this.longIndices[this.longIndicesIndex] = this.addIndex;
            this.indexLookup[this.addIndex].setLong(this.longIndicesIndex);
            ++this.longIndicesIndex;
        } else if (VectorizationContext.isFloatFamily(outputType)) {
            this.doubleIndices[this.doubleIndicesIndex] = this.addIndex;
            this.indexLookup[this.addIndex].setDouble(this.doubleIndicesIndex);
            ++this.doubleIndicesIndex;
        } else if (VectorizationContext.isStringFamily(outputType)) {
            this.stringIndices[this.stringIndicesIndex] = this.addIndex;
            this.indexLookup[this.addIndex].setString(this.stringIndicesIndex);
            ++this.stringIndicesIndex;
        } else if (VectorizationContext.isDecimalFamily(outputType)) {
            this.decimalIndices[this.decimalIndicesIndex] = this.addIndex;
            this.indexLookup[this.addIndex].setDecimal(this.decimalIndicesIndex);
            ++this.decimalIndicesIndex;
        } else {
            throw new HiveException("Unsuported vector output type: " + outputType);
        }
        ++this.addIndex;
    }

    protected void finishAdding() {
        this.longIndices = Arrays.copyOf(this.longIndices, this.longIndicesIndex);
        this.doubleIndices = Arrays.copyOf(this.doubleIndices, this.doubleIndicesIndex);
        this.stringIndices = Arrays.copyOf(this.stringIndices, this.stringIndicesIndex);
        this.decimalIndices = Arrays.copyOf(this.decimalIndices, this.decimalIndicesIndex);
    }

    public class KeyLookupHelper {
        public int longIndex;
        public int doubleIndex;
        public int stringIndex;
        public int decimalIndex;
        private static final int INDEX_UNUSED = -1;

        private void resetIndices() {
            this.decimalIndex = -1;
            this.stringIndex = -1;
            this.doubleIndex = -1;
            this.longIndex = -1;
        }

        public void setLong(int index) {
            this.resetIndices();
            this.longIndex = index;
        }

        public void setDouble(int index) {
            this.resetIndices();
            this.doubleIndex = index;
        }

        public void setString(int index) {
            this.resetIndices();
            this.stringIndex = index;
        }

        public void setDecimal(int index) {
            this.resetIndices();
            this.decimalIndex = index;
        }
    }
}

