/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.io.Text;

public class VectorUDFDateDiffColScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;
    private long longValue;
    private byte[] stringValue;
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private final transient Text text = new Text();
    private int baseDate;
    private transient Date date = new Date(0L);

    public VectorUDFDateDiffColScalar(int colNum, Object object, int outputColumn) {
        this.colNum = colNum;
        this.outputColumn = outputColumn;
        if (object instanceof Long) {
            this.longValue = (Long)object;
        } else if (object instanceof byte[]) {
            this.stringValue = (byte[])object;
        }
    }

    public VectorUDFDateDiffColScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        ColumnVector inputCol = batch.cols[this.colNum];
        int n = inputCol.isRepeating ? 1 : batch.size;
        int[] sel = batch.selected;
        if (batch.size == 0) {
            return;
        }
        outV.isRepeating = inputCol.isRepeating;
        switch (this.inputTypes[1]) {
            case DATE: {
                this.baseDate = (int)this.longValue;
                break;
            }
            case TIMESTAMP: {
                this.date.setTime(this.longValue / 1000000L);
                this.baseDate = DateWritable.dateToDays((Date)this.date);
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                try {
                    this.date.setTime(this.formatter.parse(new String(this.stringValue, "UTF-8")).getTime());
                    this.baseDate = DateWritable.dateToDays((Date)this.date);
                    break;
                }
                catch (Exception e) {
                    outV.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.isNull[i] = true;
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.isNull[i] = true;
                        }
                    }
                    return;
                }
            }
            default: {
                throw new Error("Invalid input type #1: " + this.inputTypes[1].name());
            }
        }
        switch (this.inputTypes[0]) {
            case DATE: {
                if (inputCol.noNulls) {
                    outV.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.vector[i] = this.evaluateDate(inputCol, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.vector[i] = this.evaluateDate(inputCol, i);
                        }
                    }
                } else {
                    outV.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.evaluateDate(inputCol, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.evaluateDate(inputCol, i);
                        }
                    }
                }
                break;
            }
            case TIMESTAMP: {
                if (inputCol.noNulls) {
                    outV.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.vector[i] = this.evaluateTimestamp(inputCol, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.vector[i] = this.evaluateTimestamp(inputCol, i);
                        }
                    }
                } else {
                    outV.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.evaluateTimestamp(inputCol, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.evaluateTimestamp(inputCol, i);
                        }
                    }
                }
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                if (inputCol.noNulls) {
                    outV.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            this.evaluateString(inputCol, outV, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            this.evaluateString(inputCol, outV, i);
                        }
                    }
                } else {
                    outV.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            this.evaluateString(inputCol, outV, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            this.evaluateString(inputCol, outV, i);
                        }
                    }
                }
                break;
            }
            default: {
                throw new Error("Invalid input type #0: " + this.inputTypes[0].name());
            }
        }
    }

    protected int evaluateTimestamp(ColumnVector columnVector, int index) {
        LongColumnVector lcv = (LongColumnVector)columnVector;
        this.date.setTime(lcv.vector[index] / 1000000L);
        return DateWritable.dateToDays((Date)this.date) - this.baseDate;
    }

    protected int evaluateDate(ColumnVector columnVector, int index) {
        LongColumnVector lcv = (LongColumnVector)columnVector;
        return (int)lcv.vector[index] - this.baseDate;
    }

    protected void evaluateString(ColumnVector columnVector, LongColumnVector output, int i) {
        BytesColumnVector bcv = (BytesColumnVector)columnVector;
        this.text.set(bcv.vector[i], bcv.start[i], bcv.length[i]);
        try {
            this.date.setTime(this.formatter.parse(this.text.toString()).getTime());
            output.vector[i] = DateWritable.dateToDays((Date)this.date) - this.baseDate;
        }
        catch (ParseException e) {
            output.vector[i] = 1L;
            output.isNull[i] = true;
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "long";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(int longValue) {
        this.longValue = longValue;
    }

    public byte[] getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(byte[] stringValue) {
        this.stringValue = stringValue;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_DATETIME_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING_DATETIME_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR);
        return b.build();
    }
}

