/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.docgen;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.restspec.ActionSchema;
import com.linkedin.restli.restspec.ActionsSetSchema;
import com.linkedin.restli.restspec.AssociationSchema;
import com.linkedin.restli.restspec.CollectionSchema;
import com.linkedin.restli.restspec.EntitySchema;
import com.linkedin.restli.restspec.FinderSchema;
import com.linkedin.restli.restspec.ParameterSchema;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.restspec.RestMethodSchema;
import com.linkedin.restli.restspec.SimpleSchema;
import com.linkedin.restli.server.ResourceLevel;
import java.util.List;

public interface ResourceSchemaVisitior {
    public void visitResourceSchema(VisitContext var1, ResourceSchema var2);

    public void visitCollectionResource(VisitContext var1, CollectionSchema var2);

    public void visitAssociationResource(VisitContext var1, AssociationSchema var2);

    public void visitSimpleResource(VisitContext var1, SimpleSchema var2);

    public void visitActionSetResource(VisitContext var1, ActionsSetSchema var2);

    public void visitEntityResource(VisitContext var1, EntitySchema var2);

    public void visitRestMethod(VisitContext var1, RecordTemplate var2, RestMethodSchema var3);

    public void visitFinder(VisitContext var1, RecordTemplate var2, FinderSchema var3);

    public void visitAction(VisitContext var1, RecordTemplate var2, ResourceLevel var3, ActionSchema var4);

    public void visitParameter(VisitContext var1, RecordTemplate var2, Object var3, ParameterSchema var4);

    public static class VisitContext {
        private final List<ResourceSchema> _resourceSchemaHierarchy;
        private final String _resourcePath;

        public VisitContext(List<ResourceSchema> resourceSchemaHierarchy, String resourcePath) {
            this._resourceSchemaHierarchy = resourceSchemaHierarchy;
            this._resourcePath = resourcePath;
        }

        public List<ResourceSchema> getResourceSchemaHierarchy() {
            return this._resourceSchemaHierarchy;
        }

        public String getResourcePath() {
            return this._resourcePath;
        }

        public ResourceSchema getParentSchema() {
            return this._resourceSchemaHierarchy.get(this._resourceSchemaHierarchy.size() - 1);
        }
    }
}

