/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.rest;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.gobblin.rest.JobExecutionInfoArray;

public class JobExecutionQueryResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"JobExecutionQueryResult\",\"namespace\":\"org.apache.gobblin.rest\",\"doc\":\"Gobblin job execution query result\",\"fields\":[{\"name\":\"jobExecutions\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"JobExecutionInfo\",\"doc\":\"Gobblin job execution information\",\"fields\":[{\"name\":\"jobName\",\"type\":\"string\",\"doc\":\"Job name\"},{\"name\":\"jobId\",\"type\":\"string\",\"doc\":\"Job ID\"},{\"name\":\"startTime\",\"type\":\"long\",\"doc\":\"Job start time (epoch time)\",\"optional\":true},{\"name\":\"endTime\",\"type\":\"long\",\"doc\":\"Job end time (epoch time)\",\"optional\":true},{\"name\":\"duration\",\"type\":\"long\",\"doc\":\"Job duration in milliseconds\",\"optional\":true},{\"name\":\"state\",\"type\":{\"type\":\"enum\",\"name\":\"JobStateEnum\",\"symbols\":[\"PENDING\",\"RUNNING\",\"SUCCESSFUL\",\"COMMITTED\",\"FAILED\",\"CANCELLED\"]},\"doc\":\"Job state\",\"optional\":true},{\"name\":\"launchedTasks\",\"type\":\"int\",\"doc\":\"Number of launched tasks\",\"optional\":true},{\"name\":\"completedTasks\",\"type\":\"int\",\"doc\":\"Number of completed tasks\",\"optional\":true},{\"name\":\"launcherType\",\"type\":{\"type\":\"enum\",\"name\":\"LauncherTypeEnum\",\"symbols\":[\"LOCAL\",\"MAPREDUCE\",\"CLUSTER\",\"YARN\"]},\"doc\":\"Job launcher type\",\"optional\":true},{\"name\":\"trackingUrl\",\"type\":\"string\",\"doc\":\"Job execution tracking URL\",\"optional\":true},{\"name\":\"taskExecutions\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"TaskExecutionInfo\",\"doc\":\"Gobblin task execution information\",\"fields\":[{\"name\":\"jobId\",\"type\":\"string\",\"doc\":\"Job ID\"},{\"name\":\"taskId\",\"type\":\"string\",\"doc\":\"Task ID\"},{\"name\":\"startTime\",\"type\":\"long\",\"doc\":\"Task start time (epoch time)\",\"optional\":true},{\"name\":\"endTime\",\"type\":\"long\",\"doc\":\"Task end time (epoch time)\",\"optional\":true},{\"name\":\"duration\",\"type\":\"long\",\"doc\":\"Task duration in milliseconds\",\"optional\":true},{\"name\":\"state\",\"type\":{\"type\":\"enum\",\"name\":\"TaskStateEnum\",\"symbols\":[\"PENDING\",\"RUNNING\",\"SUCCESSFUL\",\"COMMITTED\",\"FAILED\",\"CANCELLED\"]},\"doc\":\"Task state\",\"optional\":true},{\"name\":\"failureException\",\"type\":\"string\",\"doc\":\"Task failure exception message\",\"optional\":true},{\"name\":\"lowWatermark\",\"type\":\"long\",\"doc\":\"Low watermark\",\"optional\":true},{\"name\":\"highWatermark\",\"type\":\"long\",\"doc\":\"High watermark\",\"optional\":true},{\"name\":\"table\",\"type\":{\"type\":\"record\",\"name\":\"Table\",\"doc\":\"Gobblin table definition\",\"fields\":[{\"name\":\"namespace\",\"type\":\"string\",\"doc\":\"Table namespace\",\"optional\":true},{\"name\":\"name\",\"type\":\"string\",\"doc\":\"Table name\"},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"TableTypeEnum\",\"symbols\":[\"SNAPSHOT_ONLY\",\"SNAPSHOT_APPEND\",\"APPEND_ONLY\"]},\"doc\":\"Table type\",\"optional\":true}]},\"doc\":\"Table definition\",\"optional\":true},{\"name\":\"taskProperties\",\"type\":{\"type\":\"map\",\"values\":\"string\"},\"doc\":\"Task properties\",\"optional\":true},{\"name\":\"metrics\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"Metric\",\"doc\":\"Gobblin metric\",\"fields\":[{\"name\":\"group\",\"type\":\"string\",\"doc\":\"Metric group\"},{\"name\":\"name\",\"type\":\"string\",\"doc\":\"Metric name\"},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"MetricTypeEnum\",\"symbols\":[\"COUNTER\",\"METER\",\"GAUGE\"]},\"doc\":\"Metric type\"},{\"name\":\"value\",\"type\":\"string\",\"doc\":\"Metric value\"}]}},\"doc\":\"Job metrics\"}]}},\"doc\":\"An array of task execution information records\"},{\"name\":\"jobProperties\",\"type\":{\"type\":\"map\",\"values\":\"string\"},\"doc\":\"Job properties\",\"optional\":true},{\"name\":\"metrics\",\"type\":{\"type\":\"array\",\"items\":\"Metric\"},\"doc\":\"Job metrics\"}]}},\"doc\":\"An array of job execution information records\"}]}");
    private static final RecordDataSchema.Field FIELD_JobExecutions = SCHEMA.getField("jobExecutions");

    public JobExecutionQueryResult() {
        super(new DataMap(), SCHEMA);
    }

    public JobExecutionQueryResult(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasJobExecutions() {
        return this.contains(FIELD_JobExecutions);
    }

    public void removeJobExecutions() {
        this.remove(FIELD_JobExecutions);
    }

    public JobExecutionInfoArray getJobExecutions(GetMode mode) {
        return (JobExecutionInfoArray)this.obtainWrapped(FIELD_JobExecutions, JobExecutionInfoArray.class, mode);
    }

    @Nonnull
    public JobExecutionInfoArray getJobExecutions() {
        return (JobExecutionInfoArray)this.obtainWrapped(FIELD_JobExecutions, JobExecutionInfoArray.class, GetMode.STRICT);
    }

    public JobExecutionQueryResult setJobExecutions(JobExecutionInfoArray value, SetMode mode) {
        this.putWrapped(FIELD_JobExecutions, JobExecutionInfoArray.class, (DataTemplate)value, mode);
        return this;
    }

    public JobExecutionQueryResult setJobExecutions(@Nonnull JobExecutionInfoArray value) {
        this.putWrapped(FIELD_JobExecutions, JobExecutionInfoArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobExecutionQueryResult clone() throws CloneNotSupportedException {
        return (JobExecutionQueryResult)super.clone();
    }

    public JobExecutionQueryResult copy() throws CloneNotSupportedException {
        return (JobExecutionQueryResult)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public JobExecutionInfoArray.Fields jobExecutions() {
            return new JobExecutionInfoArray.Fields(this.getPathComponents(), "jobExecutions");
        }
    }
}

