/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.common.Version;
import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.Callbacks;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.data.ByteString;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.codec.PsonDataCodec;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.multipart.MultiPartMIMEUtils;
import com.linkedin.multipart.MultiPartMIMEWriter;
import com.linkedin.r2.disruptor.DisruptContext;
import com.linkedin.r2.message.MessageHeadersBuilder;
import com.linkedin.r2.message.Messages;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamRequestBuilder;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.entitystream.ByteStringWriter;
import com.linkedin.restli.client.Client;
import com.linkedin.restli.client.ErrorHandlingBehavior;
import com.linkedin.restli.client.ProtocolVersionOption;
import com.linkedin.restli.client.Request;
import com.linkedin.restli.client.RequestBuilder;
import com.linkedin.restli.client.Response;
import com.linkedin.restli.client.ResponseFuture;
import com.linkedin.restli.client.RestLiCallbackAdapter;
import com.linkedin.restli.client.RestLiStreamCallbackAdapter;
import com.linkedin.restli.client.RestliRequestOptions;
import com.linkedin.restli.client.multiplexer.MultiplexedCallback;
import com.linkedin.restli.client.multiplexer.MultiplexedRequest;
import com.linkedin.restli.client.multiplexer.MultiplexedResponse;
import com.linkedin.restli.client.uribuilders.MultiplexerUriBuilder;
import com.linkedin.restli.client.uribuilders.RestliUriBuilderUtil;
import com.linkedin.restli.common.HttpMethod;
import com.linkedin.restli.common.OperationNameGenerator;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.common.attachments.RestLiAttachmentDataSourceWriter;
import com.linkedin.restli.common.attachments.RestLiDataSourceIterator;
import com.linkedin.restli.disruptor.DisruptRestController;
import com.linkedin.restli.disruptor.DisruptRestControllerContainer;
import com.linkedin.restli.internal.client.RequestBodyTransformer;
import com.linkedin.restli.internal.client.ResponseFutureImpl;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.common.AttachmentUtils;
import com.linkedin.restli.internal.common.CookieUtil;
import com.linkedin.util.ArgumentUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.mail.internet.ParseException;

public class RestClient
implements Client {
    private static final JacksonDataCodec JACKSON_DATA_CODEC = new JacksonDataCodec();
    private static final PsonDataCodec PSON_DATA_CODEC = new PsonDataCodec();
    private static final List<AcceptType> DEFAULT_ACCEPT_TYPES = Collections.emptyList();
    private static final ContentType DEFAULT_CONTENT_TYPE = ContentType.JSON;
    private static final Random RANDOM_INSTANCE = new Random();
    private final com.linkedin.r2.transport.common.Client _client;
    private final String _uriPrefix;
    private final List<AcceptType> _acceptTypes;
    private final ContentType _contentType;
    private final boolean _forceUseNextVersionOverride = "true".equalsIgnoreCase(System.getProperty("restli.forceUseNextVersionOverride"));

    public RestClient(com.linkedin.r2.transport.common.Client client, String uriPrefix) {
        this(client, uriPrefix, DEFAULT_CONTENT_TYPE, DEFAULT_ACCEPT_TYPES);
    }

    @Deprecated
    public RestClient(com.linkedin.r2.transport.common.Client client, String uriPrefix, List<AcceptType> acceptTypes) {
        this(client, uriPrefix, DEFAULT_CONTENT_TYPE, acceptTypes);
    }

    @Deprecated
    public RestClient(com.linkedin.r2.transport.common.Client client, String uriPrefix, ContentType contentType, List<AcceptType> acceptTypes) {
        this._client = client;
        this._uriPrefix = uriPrefix == null ? null : uriPrefix.trim();
        this._acceptTypes = acceptTypes;
        this._contentType = contentType;
    }

    @Override
    public void shutdown(Callback<None> callback) {
        this._client.shutdown(callback);
    }

    @Deprecated
    public String getURIPrefix() {
        return this._uriPrefix;
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(Request<T> request, RequestContext requestContext) {
        FutureCallback callback = new FutureCallback();
        this.sendRequest(request, requestContext, (Callback<Response<T>>)callback);
        return new ResponseFutureImpl(callback);
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(Request<T> request, RequestContext requestContext, ErrorHandlingBehavior errorHandlingBehavior) {
        FutureCallback callback = new FutureCallback();
        this.sendRequest(request, requestContext, (Callback<Response<T>>)callback);
        return new ResponseFutureImpl(callback, errorHandlingBehavior);
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(RequestBuilder<? extends Request<T>> requestBuilder, RequestContext requestContext) {
        return this.sendRequest(requestBuilder.build(), requestContext);
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(RequestBuilder<? extends Request<T>> requestBuilder, RequestContext requestContext, ErrorHandlingBehavior errorHandlingBehavior) {
        return this.sendRequest(requestBuilder.build(), requestContext, errorHandlingBehavior);
    }

    @Override
    public <T> void sendRequest(Request<T> request, RequestContext requestContext, Callback<Response<T>> callback) {
        if (request.getStreamingAttachments() != null || request.getRequestOptions().getAcceptResponseAttachments()) {
            this.sendStreamRequest(request, requestContext, new RestLiStreamCallbackAdapter<T>(request.getResponseDecoder(), callback));
        } else {
            this.sendRestRequest(request, requestContext, (Callback<RestResponse>)new RestLiCallbackAdapter<T>(request.getResponseDecoder(), callback));
        }
    }

    private <T> void sendStreamRequest(Request<T> request, RequestContext requestContext, Callback<StreamResponse> callback) {
        RecordTemplate input = request.getInputRecord();
        ProtocolVersion protocolVersion = this.getProtocolVersionForService(request);
        URI requestUri = RestliUriBuilderUtil.createUriBuilder(request, this._uriPrefix, protocolVersion).build();
        ResourceMethod method = request.getMethod();
        String methodName = request.getMethodName();
        this.addDisruptContext(request.getBaseUriTemplate(), method, methodName, requestContext);
        this.sendStreamRequestImpl(requestContext, requestUri, method, input != null ? RequestBodyTransformer.transform(request, protocolVersion) : null, request.getHeaders(), CookieUtil.encodeCookies(request.getCookies()), methodName, protocolVersion, request.getRequestOptions(), request.getStreamingAttachments(), callback);
    }

    @Deprecated
    public <T> void sendRestRequest(Request<T> request, RequestContext requestContext, Callback<RestResponse> callback) {
        if (request.getStreamingAttachments() != null) {
            throw new UnsupportedOperationException("Cannot stream attachments using RestRequest/RestResponse!");
        }
        if (request.getRequestOptions() != null && request.getRequestOptions().getAcceptResponseAttachments()) {
            throw new UnsupportedOperationException("Cannot expect streaming attachments using RestRequest/RestResponse!");
        }
        RecordTemplate input = request.getInputRecord();
        ProtocolVersion protocolVersion = this.getProtocolVersionForService(request);
        URI requestUri = RestliUriBuilderUtil.createUriBuilder(request, this._uriPrefix, protocolVersion).build();
        ResourceMethod method = request.getMethod();
        String methodName = request.getMethodName();
        this.addDisruptContext(request.getBaseUriTemplate(), method, methodName, requestContext);
        this.sendRestRequestImpl(requestContext, requestUri, method, input != null ? RequestBodyTransformer.transform(request, protocolVersion) : null, request.getHeaders(), CookieUtil.encodeCookies(request.getCookies()), methodName, protocolVersion, request.getRequestOptions(), callback);
    }

    private ProtocolVersion getProtocolVersionForService(Request<?> request) {
        try {
            return RestClient.getProtocolVersion(AllProtocolVersions.BASELINE_PROTOCOL_VERSION, AllProtocolVersions.PREVIOUS_PROTOCOL_VERSION, AllProtocolVersions.LATEST_PROTOCOL_VERSION, AllProtocolVersions.NEXT_PROTOCOL_VERSION, RestClient.getAnnouncedVersion(this._client.getMetadata(new URI(this._uriPrefix + request.getServiceName()))), request.getRequestOptions().getProtocolVersionOption(), this._forceUseNextVersionOverride);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create a valid URI to fetch properties for!");
        }
    }

    static ProtocolVersion getAnnouncedVersion(Map<String, Object> properties) {
        if (properties == null) {
            throw new RuntimeException("No valid properties found!");
        }
        Object potentialAnnouncedVersion = properties.get("restli.protocol");
        if (potentialAnnouncedVersion == null) {
            return AllProtocolVersions.BASELINE_PROTOCOL_VERSION;
        }
        Object potentialAnnouncedVersionPercentage = properties.get("restli.protocol.percentage");
        if (potentialAnnouncedVersionPercentage == null) {
            return new ProtocolVersion(potentialAnnouncedVersion.toString());
        }
        try {
            int announceVersionPercentage = Integer.parseInt(potentialAnnouncedVersionPercentage.toString());
            return announceVersionPercentage > 0 && announceVersionPercentage <= 100 && RANDOM_INSTANCE.nextInt(100) + 1 <= announceVersionPercentage ? new ProtocolVersion(potentialAnnouncedVersion.toString()) : AllProtocolVersions.BASELINE_PROTOCOL_VERSION;
        }
        catch (NumberFormatException e) {
            return AllProtocolVersions.BASELINE_PROTOCOL_VERSION;
        }
    }

    static ProtocolVersion getProtocolVersion(ProtocolVersion baselineProtocolVersion, ProtocolVersion previousVersion, ProtocolVersion latestVersion, ProtocolVersion nextVersion, ProtocolVersion announcedVersion, ProtocolVersionOption versionOption, boolean forceUseNextVersionOverride) {
        if (versionOption == null) {
            throw new IllegalArgumentException("versionOptions cannot be null!");
        }
        if (forceUseNextVersionOverride) {
            return nextVersion;
        }
        switch (versionOption) {
            case FORCE_USE_NEXT: {
                return nextVersion;
            }
            case FORCE_USE_LATEST: {
                return latestVersion;
            }
            case FORCE_USE_PREVIOUS: {
                return previousVersion;
            }
            case USE_LATEST_IF_AVAILABLE: {
                if (announcedVersion.compareTo((Version)previousVersion) == -1) {
                    throw new RuntimeException("Announced version is less than the earliest supported version!Announced version: " + announcedVersion + ", earliest supported version: " + previousVersion);
                }
                if (announcedVersion.compareTo((Version)previousVersion) == 0) {
                    return previousVersion;
                }
                if (announcedVersion.compareTo((Version)latestVersion) == -1) {
                    return announcedVersion;
                }
                return latestVersion;
            }
        }
        return baselineProtocolVersion;
    }

    private void addAcceptHeaders(MessageHeadersBuilder<?> builder, List<AcceptType> acceptTypes, boolean acceptAttachments) {
        if (builder.getHeader("Accept") == null) {
            List<AcceptType> types = this._acceptTypes;
            if (acceptTypes != null && !acceptTypes.isEmpty()) {
                types = acceptTypes;
            }
            if (types != null && !types.isEmpty()) {
                builder.setHeader("Accept", this.createAcceptHeader(types, acceptAttachments));
            } else if (acceptAttachments) {
                builder.setHeader("Accept", this.createAcceptHeader(Collections.emptyList(), acceptAttachments));
            }
        }
    }

    private String createAcceptHeader(List<AcceptType> acceptTypes, boolean acceptAttachments) {
        if (acceptTypes.size() == 1 && !acceptAttachments) {
            return acceptTypes.get(0).getHeaderKey();
        }
        StringBuilder acceptHeader = new StringBuilder();
        double currQ = 1.0;
        Iterator<AcceptType> iterator = acceptTypes.iterator();
        while (iterator.hasNext()) {
            acceptHeader.append(iterator.next().getHeaderKey());
            acceptHeader.append(";q=");
            acceptHeader.append(currQ);
            currQ -= 0.1;
            if (!iterator.hasNext()) continue;
            acceptHeader.append(",");
        }
        if (acceptAttachments) {
            if (acceptTypes.size() > 0) {
                acceptHeader.append(",");
            }
            acceptHeader.append("multipart/related");
            acceptHeader.append(";q=");
            acceptHeader.append(currQ);
        }
        return acceptHeader.toString();
    }

    private ContentType resolveContentType(MessageHeadersBuilder<?> builder, DataMap dataMap, ContentType contentType) throws IOException {
        if (dataMap != null) {
            ContentType type;
            String header = builder.getHeader("Content-Type");
            if (header == null) {
                type = contentType != null ? contentType : (this._contentType != null ? this._contentType : DEFAULT_CONTENT_TYPE);
            } else {
                javax.mail.internet.ContentType headerContentType;
                try {
                    headerContentType = new javax.mail.internet.ContentType(header);
                }
                catch (ParseException e) {
                    throw new IllegalStateException("Unable to parse Content-Type: " + header);
                }
                if (headerContentType.getBaseType().equalsIgnoreCase("application/json")) {
                    type = ContentType.JSON;
                } else if (headerContentType.getBaseType().equalsIgnoreCase("application/x-pson")) {
                    type = ContentType.PSON;
                } else {
                    throw new IllegalStateException("Unknown Content-Type: " + headerContentType.toString());
                }
            }
            return type;
        }
        return null;
    }

    @Override
    public <T> void sendRequest(RequestBuilder<? extends Request<T>> requestBuilder, RequestContext requestContext, Callback<Response<T>> callback) {
        this.sendRequest(requestBuilder.build(), requestContext, callback);
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(Request<T> request) {
        return this.sendRequest(request, new RequestContext());
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(Request<T> request, ErrorHandlingBehavior errorHandlingBehavior) {
        return this.sendRequest(request, new RequestContext(), errorHandlingBehavior);
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(RequestBuilder<? extends Request<T>> requestBuilder) {
        return this.sendRequest(requestBuilder.build(), new RequestContext());
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(RequestBuilder<? extends Request<T>> requestBuilder, ErrorHandlingBehavior errorHandlingBehavior) {
        return this.sendRequest(requestBuilder.build(), new RequestContext(), errorHandlingBehavior);
    }

    @Override
    public <T> void sendRequest(Request<T> request, Callback<Response<T>> callback) {
        this.sendRequest(request, new RequestContext(), callback);
    }

    @Override
    public <T> void sendRequest(RequestBuilder<? extends Request<T>> requestBuilder, Callback<Response<T>> callback) {
        this.sendRequest(requestBuilder.build(), new RequestContext(), callback);
    }

    @Override
    public void sendRequest(MultiplexedRequest multiplexedRequest) {
        this.sendRequest(multiplexedRequest, (Callback<MultiplexedResponse>)Callbacks.empty());
    }

    @Override
    public void sendRequest(MultiplexedRequest multiplexedRequest, Callback<MultiplexedResponse> callback) {
        this.sendRequest(multiplexedRequest, new RequestContext(), callback);
    }

    @Override
    public void sendRequest(MultiplexedRequest multiplexedRequest, RequestContext requestContext, Callback<MultiplexedResponse> callback) {
        MultiplexedCallback muxCallback = new MultiplexedCallback(multiplexedRequest.getCallbacks(), callback);
        this.addDisruptContext("mux", requestContext);
        try {
            RestRequest restRequest = this.buildMultiplexedRequest(multiplexedRequest);
            this._client.restRequest(restRequest, requestContext, (Callback)muxCallback);
        }
        catch (Exception e) {
            muxCallback.onError(e);
        }
    }

    private RestRequest buildMultiplexedRequest(MultiplexedRequest multiplexedRequest) throws IOException {
        URI requestUri = new MultiplexerUriBuilder(this._uriPrefix).build();
        RestRequestBuilder requestBuilder = (RestRequestBuilder)new RestRequestBuilder(requestUri).setMethod(HttpMethod.POST.toString());
        this.addAcceptHeaders((MessageHeadersBuilder<?>)requestBuilder, Collections.singletonList(AcceptType.JSON), false);
        DataMap multiplexedPayload = multiplexedRequest.getContent().data();
        ContentType type = this.resolveContentType((MessageHeadersBuilder<?>)requestBuilder, multiplexedPayload, ContentType.JSON);
        assert (type != null);
        requestBuilder.setHeader("Content-Type", type.getHeaderKey());
        switch (type) {
            case PSON: {
                requestBuilder.setEntity(PSON_DATA_CODEC.mapToBytes(multiplexedPayload));
                break;
            }
            case JSON: {
                requestBuilder.setEntity(JACKSON_DATA_CODEC.mapToBytes(multiplexedPayload));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ContentType:" + (Object)((Object)type));
            }
        }
        requestBuilder.setHeader("X-RestLi-Protocol-Version", AllProtocolVersions.RESTLI_PROTOCOL_2_0_0.getProtocolVersion().toString());
        return requestBuilder.build();
    }

    private void sendRestRequestImpl(RequestContext requestContext, URI uri, ResourceMethod method, DataMap dataMap, Map<String, String> headers, List<String> cookies, String methodName, ProtocolVersion protocolVersion, RestliRequestOptions requestOptions, Callback<RestResponse> callback) {
        try {
            RestRequest request = this.buildRestRequest(uri, method, dataMap, headers, cookies, protocolVersion, requestOptions.getContentType(), requestOptions.getAcceptTypes(), false);
            String operation = OperationNameGenerator.generate((ResourceMethod)method, (String)methodName);
            requestContext.putLocalAttr("OPERATION", (Object)operation);
            requestContext.putLocalAttr("REQUEST_COMPRESSION_OVERRIDE", (Object)requestOptions.getRequestCompressionOverride());
            requestContext.putLocalAttr("RESPONSE_COMPRESSION_OVERRIDE", (Object)requestOptions.getResponseCompressionOverride());
            this._client.restRequest(request, requestContext, callback);
        }
        catch (Exception e) {
            callback.onError((Throwable)e);
        }
    }

    private void sendStreamRequestImpl(RequestContext requestContext, URI uri, ResourceMethod method, DataMap dataMap, Map<String, String> headers, List<String> cookies, String methodName, ProtocolVersion protocolVersion, RestliRequestOptions requestOptions, List<Object> streamingAttachments, Callback<StreamResponse> callback) {
        try {
            StreamRequest request = this.buildStreamRequest(uri, method, dataMap, headers, cookies, protocolVersion, requestOptions.getContentType(), requestOptions.getAcceptTypes(), requestOptions.getAcceptResponseAttachments(), streamingAttachments);
            String operation = OperationNameGenerator.generate((ResourceMethod)method, (String)methodName);
            requestContext.putLocalAttr("OPERATION", (Object)operation);
            requestContext.putLocalAttr("REQUEST_COMPRESSION_OVERRIDE", (Object)requestOptions.getRequestCompressionOverride());
            requestContext.putLocalAttr("RESPONSE_COMPRESSION_OVERRIDE", (Object)requestOptions.getResponseCompressionOverride());
            this._client.streamRequest(request, requestContext, callback);
        }
        catch (Exception e) {
            callback.onError((Throwable)e);
        }
    }

    private RestRequest buildRestRequest(URI uri, ResourceMethod method, DataMap dataMap, Map<String, String> headers, List<String> cookies, ProtocolVersion protocolVersion, ContentType contentType, List<AcceptType> acceptTypes, boolean acceptResponseAttachments) throws Exception {
        RestRequestBuilder requestBuilder = (RestRequestBuilder)new RestRequestBuilder(uri).setMethod(method.getHttpMethod().toString());
        requestBuilder.setHeaders(headers);
        requestBuilder.setCookies(cookies);
        this.addAcceptHeaders((MessageHeadersBuilder<?>)requestBuilder, acceptTypes, acceptResponseAttachments);
        ContentType type = this.resolveContentType((MessageHeadersBuilder<?>)requestBuilder, dataMap, contentType);
        if (type != null) {
            requestBuilder.setHeader("Content-Type", type.getHeaderKey());
            switch (type) {
                case PSON: {
                    requestBuilder.setEntity(PSON_DATA_CODEC.mapToBytes(dataMap));
                    break;
                }
                case JSON: {
                    requestBuilder.setEntity(JACKSON_DATA_CODEC.mapToBytes(dataMap));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown ContentType:" + (Object)((Object)type));
                }
            }
        }
        this.addProtocolVersionHeader((MessageHeadersBuilder<?>)requestBuilder, protocolVersion);
        if (method.getHttpMethod() == HttpMethod.POST) {
            requestBuilder.setHeader("X-RestLi-Method", method.toString());
        }
        return requestBuilder.build();
    }

    private StreamRequest buildStreamRequest(URI uri, ResourceMethod method, DataMap dataMap, Map<String, String> headers, List<String> cookies, ProtocolVersion protocolVersion, ContentType contentType, List<AcceptType> acceptTypes, boolean acceptResponseAttachments, List<Object> streamingAttachments) throws Exception {
        StreamRequestBuilder requestBuilder = (StreamRequestBuilder)new StreamRequestBuilder(uri).setMethod(method.getHttpMethod().toString());
        requestBuilder.setHeaders(headers);
        requestBuilder.setCookies(cookies);
        this.addAcceptHeaders((MessageHeadersBuilder<?>)requestBuilder, acceptTypes, acceptResponseAttachments);
        this.addProtocolVersionHeader((MessageHeadersBuilder<?>)requestBuilder, protocolVersion);
        if (method.getHttpMethod() == HttpMethod.POST) {
            requestBuilder.setHeader("X-RestLi-Method", method.toString());
        }
        if (streamingAttachments != null) {
            ByteStringWriter firstPartWriter;
            ContentType type = this.resolveContentType((MessageHeadersBuilder<?>)requestBuilder, dataMap, contentType);
            assert (type != null);
            switch (type) {
                case PSON: {
                    firstPartWriter = new ByteStringWriter(ByteString.copy((byte[])PSON_DATA_CODEC.mapToBytes(dataMap)));
                    break;
                }
                case JSON: {
                    firstPartWriter = new ByteStringWriter(ByteString.copy((byte[])JACKSON_DATA_CODEC.mapToBytes(dataMap)));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown ContentType:" + (Object)((Object)type));
                }
            }
            MultiPartMIMEWriter.Builder attachmentsBuilder = new MultiPartMIMEWriter.Builder();
            for (Object dataSource : streamingAttachments) {
                assert (dataSource instanceof RestLiAttachmentDataSourceWriter || dataSource instanceof RestLiDataSourceIterator);
                if (dataSource instanceof RestLiAttachmentDataSourceWriter) {
                    AttachmentUtils.appendSingleAttachmentToBuilder((MultiPartMIMEWriter.Builder)attachmentsBuilder, (RestLiAttachmentDataSourceWriter)((RestLiAttachmentDataSourceWriter)dataSource));
                    continue;
                }
                AttachmentUtils.appendMultipleAttachmentsToBuilder((MultiPartMIMEWriter.Builder)attachmentsBuilder, (RestLiDataSourceIterator)((RestLiDataSourceIterator)dataSource));
            }
            MultiPartMIMEWriter multiPartMIMEWriter = AttachmentUtils.createMultiPartMIMEWriter((ByteStringWriter)firstPartWriter, (String)type.getHeaderKey(), (MultiPartMIMEWriter.Builder)attachmentsBuilder);
            String contentTypeHeader = MultiPartMIMEUtils.buildMIMEContentTypeHeader((String)"related", (String)multiPartMIMEWriter.getBoundary(), Collections.emptyMap());
            requestBuilder.setHeader("Content-Type", contentTypeHeader);
            return requestBuilder.build(multiPartMIMEWriter.getEntityStream());
        }
        assert (acceptResponseAttachments);
        return Messages.toStreamRequest((RestRequest)this.buildRestRequest(uri, method, dataMap, headers, cookies, protocolVersion, contentType, acceptTypes, acceptResponseAttachments));
    }

    private void addProtocolVersionHeader(MessageHeadersBuilder<?> builder, ProtocolVersion protocolVersion) {
        builder.setHeader("X-RestLi-Protocol-Version", protocolVersion.toString());
    }

    private void addDisruptContext(String resource, RequestContext requestContext) {
        this.addDisruptContext(resource, null, null, requestContext);
    }

    private void addDisruptContext(String resource, ResourceMethod method, String name, RequestContext requestContext) {
        DisruptRestController controller = DisruptRestControllerContainer.getInstance();
        if (controller == null) {
            return;
        }
        if (requestContext.getLocalAttr("R2_DISRUPT_SOURCE") != null) {
            return;
        }
        ArgumentUtil.notNull((Object)resource, (String)"resource");
        DisruptContext disruptContext = method == null ? controller.getDisruptContext(resource) : (name == null ? controller.getDisruptContext(resource, method) : controller.getDisruptContext(resource, method, name));
        requestContext.putLocalAttr("R2_DISRUPT_SOURCE", (Object)controller.getClass().getCanonicalName());
        if (disruptContext != null) {
            requestContext.putLocalAttr("R2_DISRUPT_CONTEXT", (Object)disruptContext);
        }
    }

    public static enum ContentType {
        PSON("application/x-pson"),
        JSON("application/json");

        private String _headerKey;

        private ContentType(String headerKey) {
            this._headerKey = headerKey;
        }

        public String getHeaderKey() {
            return this._headerKey;
        }
    }

    public static enum AcceptType {
        PSON("application/x-pson"),
        JSON("application/json"),
        ANY("*/*");

        private String _headerKey;

        private AcceptType(String headerKey) {
            this._headerKey = headerKey;
        }

        public String getHeaderKey() {
            return this._headerKey;
        }
    }
}

