/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client.multiplexer;

import com.linkedin.common.callback.Callback;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.JacksonDataTemplateCodec;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.restli.client.Request;
import com.linkedin.restli.client.Response;
import com.linkedin.restli.client.RestLiCallbackAdapter;
import com.linkedin.restli.client.RestLiEncodingException;
import com.linkedin.restli.client.multiplexer.MultiplexedRequest;
import com.linkedin.restli.client.multiplexer.RequestWithCallback;
import com.linkedin.restli.client.uribuilders.RestliUriBuilderUtil;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.multiplexer.IndividualBody;
import com.linkedin.restli.common.multiplexer.IndividualRequest;
import com.linkedin.restli.common.multiplexer.IndividualRequestMap;
import com.linkedin.restli.common.multiplexer.MultiplexedRequestContent;
import com.linkedin.restli.internal.client.RequestBodyTransformer;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiplexedRequestBuilder {
    private static final JacksonDataTemplateCodec TEMPLATE_CODEC = new JacksonDataTemplateCodec();
    private final List<RequestWithCallback<?>> _requestsWithCallbacks = new ArrayList();
    private final boolean _isParallel;

    public static MultiplexedRequestBuilder createParallelRequest() {
        return new MultiplexedRequestBuilder(true);
    }

    public static MultiplexedRequestBuilder createSequentialRequest() {
        return new MultiplexedRequestBuilder(false);
    }

    private MultiplexedRequestBuilder(boolean isParallel) {
        this._isParallel = isParallel;
    }

    public <T> MultiplexedRequestBuilder addRequest(Request<T> request, Callback<Response<T>> callback) {
        this._requestsWithCallbacks.add(new RequestWithCallback<T>(request, callback));
        return this;
    }

    public MultiplexedRequest build() throws RestLiEncodingException {
        if (this._requestsWithCallbacks.isEmpty()) {
            throw new IllegalStateException("No requests provided for multiplexing");
        }
        if (this._isParallel) {
            return this.buildParallel();
        }
        return this.buildSequential();
    }

    private MultiplexedRequest buildParallel() throws RestLiEncodingException {
        HashMap<Integer, Callback<RestResponse>> callbacks = new HashMap<Integer, Callback<RestResponse>>(this._requestsWithCallbacks.size());
        IndividualRequestMap individualRequests = new IndividualRequestMap(this._requestsWithCallbacks.size());
        IndividualRequestMap dependentRequests = new IndividualRequestMap();
        for (int i = 0; i < this._requestsWithCallbacks.size(); ++i) {
            RequestWithCallback<?> requestWithCallback = this._requestsWithCallbacks.get(i);
            IndividualRequest individualRequest = MultiplexedRequestBuilder.toIndividualRequest(requestWithCallback.getRequest(), dependentRequests);
            individualRequests.put(Integer.toString(i), (DataTemplate)individualRequest);
            callbacks.put(i, MultiplexedRequestBuilder.wrapCallback(requestWithCallback));
        }
        return MultiplexedRequestBuilder.toMultiplexedRequest(individualRequests, callbacks);
    }

    private MultiplexedRequest buildSequential() throws RestLiEncodingException {
        HashMap<Integer, Callback<RestResponse>> callbacks = new HashMap<Integer, Callback<RestResponse>>(this._requestsWithCallbacks.size());
        IndividualRequestMap dependentRequests = new IndividualRequestMap();
        for (int i = this._requestsWithCallbacks.size() - 1; i >= 0; --i) {
            RequestWithCallback<?> requestWithCallback = this._requestsWithCallbacks.get(i);
            IndividualRequest individualRequest = MultiplexedRequestBuilder.toIndividualRequest(requestWithCallback.getRequest(), dependentRequests);
            dependentRequests = new IndividualRequestMap();
            dependentRequests.put(Integer.toString(i), (DataTemplate)individualRequest);
            callbacks.put(i, MultiplexedRequestBuilder.wrapCallback(requestWithCallback));
        }
        return MultiplexedRequestBuilder.toMultiplexedRequest(dependentRequests, callbacks);
    }

    private static Callback<RestResponse> wrapCallback(RequestWithCallback<?> requestWithCallback) {
        return new RestLiCallbackAdapter(requestWithCallback.getRequest().getResponseDecoder(), requestWithCallback.getCallback());
    }

    private static IndividualRequest toIndividualRequest(Request<?> request, IndividualRequestMap dependantRequests) throws RestLiEncodingException {
        ProtocolVersion protocolVersion = AllProtocolVersions.RESTLI_PROTOCOL_2_0_0.getProtocolVersion();
        String relativeUrl = MultiplexedRequestBuilder.getRelativeUrl(request, protocolVersion);
        IndividualRequest individualRequest = new IndividualRequest();
        individualRequest.setRelativeUrl(relativeUrl);
        individualRequest.setMethod(request.getMethod().getHttpMethod().name());
        individualRequest.setHeaders(new StringMap(request.getHeaders()));
        List<HttpCookie> cookies = request.getCookies();
        if (cookies != null && !cookies.isEmpty()) {
            throw new IllegalArgumentException(String.format("Cookies for individual request '%s' MUST be added at the envelope request level", relativeUrl));
        }
        individualRequest.setBody(MultiplexedRequestBuilder.getBody(request, protocolVersion), SetMode.IGNORE_NULL);
        individualRequest.setDependentRequests(dependantRequests);
        return individualRequest;
    }

    private static String getRelativeUrl(Request<?> request, ProtocolVersion protocolVersion) {
        URI requestUri = RestliUriBuilderUtil.createUriBuilder(request, "", protocolVersion).build();
        return requestUri.toString();
    }

    private static IndividualBody getBody(Request<?> request, ProtocolVersion protocolVersion) throws RestLiEncodingException {
        RecordTemplate record = request.getInputRecord();
        if (record == null) {
            return null;
        }
        return new IndividualBody(RequestBodyTransformer.transform(request, protocolVersion));
    }

    private static MultiplexedRequest toMultiplexedRequest(IndividualRequestMap individualRequests, Map<Integer, Callback<RestResponse>> callbacks) {
        MultiplexedRequestContent multiplexedRequestContent = new MultiplexedRequestContent();
        multiplexedRequestContent.setRequests(individualRequests);
        return new MultiplexedRequest(multiplexedRequestContent, callbacks);
    }
}

