/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.collections;

import com.linkedin.data.collections.CommonList;
import com.linkedin.data.collections.ListChecker;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CheckedList<E>
extends AbstractList<E>
implements CommonList<E>,
Cloneable {
    protected ListChecker<E> _checker;
    private boolean _readOnly = false;
    private InternalList<E> _list;

    public CheckedList() {
        this._checker = null;
        this._list = new InternalList();
    }

    public CheckedList(List<? extends E> list) {
        this._checker = null;
        this.checkAll(list);
        this._list = new InternalList<E>(list);
    }

    public CheckedList(int initialCapacity) {
        this._checker = null;
        this._list = new InternalList(initialCapacity);
    }

    public CheckedList(ListChecker<E> checker) {
        this._checker = checker;
        this._list = new InternalList();
    }

    public CheckedList(List<? extends E> list, ListChecker<E> checker) {
        this._checker = checker;
        this.checkAll(list);
        this._list = new InternalList<E>(list);
    }

    public CheckedList(int initialCapacity, ListChecker<E> checker) {
        this._checker = checker;
        this._list = new InternalList(initialCapacity);
    }

    @Override
    public boolean add(E e) {
        this.check(e);
        this.checkMutability();
        return this._list.add(e);
    }

    @Override
    public void add(int index, E element) {
        this.check(element);
        this.checkMutability();
        this._list.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.checkAll(c);
        this.checkMutability();
        return this._list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkAll(c);
        this.checkMutability();
        return this._list.addAll(index, c);
    }

    @Override
    public void clear() {
        this.checkMutability();
        this._list.clear();
    }

    @Override
    public CheckedList<E> clone() throws CloneNotSupportedException {
        CheckedList o = (CheckedList)super.clone();
        o._list = (InternalList)this._list.clone();
        o._readOnly = false;
        return o;
    }

    @Override
    public boolean contains(Object o) {
        return this._list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._list.containsAll(c);
    }

    @Override
    public boolean equals(Object object) {
        return this._list.equals(object);
    }

    @Override
    public E get(int index) {
        return this._list.get(index);
    }

    @Override
    public int hashCode() {
        return this._list.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this._list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this._list.isEmpty();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this._list.lastIndexOf(o);
    }

    @Override
    public E remove(int index) {
        this.checkMutability();
        return this._list.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this.checkMutability();
        return this._list.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkMutability();
        return this._list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkMutability();
        return this._list.retainAll(c);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.checkMutability();
        this._list.removeRange(fromIndex, toIndex);
    }

    @Override
    public E set(int index, E element) {
        this.check(element);
        this.checkMutability();
        return this._list.set(index, element);
    }

    @Override
    public int size() {
        return this._list.size();
    }

    @Override
    public Object[] toArray() {
        return this._list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._list.toArray(a);
    }

    @Override
    public String toString() {
        return this._list.toString();
    }

    @Override
    public boolean isReadOnly() {
        return this._readOnly;
    }

    @Override
    public void setReadOnly() {
        this._readOnly = true;
    }

    @Override
    public void invalidate() {
        this._list = null;
    }

    protected boolean addWithoutChecking(E element) {
        this.checkMutability();
        return this._list.add(element);
    }

    protected E setWithoutChecking(int index, E element) {
        this.checkMutability();
        return this._list.set(index, element);
    }

    boolean addWithAssertChecking(E element) {
        assert (this.assertCheck(element)) : "Check is failed";
        return this.addWithoutChecking(element);
    }

    E setWithAssertChecking(int index, E element) {
        assert (this.assertCheck(element)) : "Check is failed";
        return this.setWithoutChecking(index, element);
    }

    private final void checkMutability() {
        if (this._readOnly) {
            throw new UnsupportedOperationException("Cannot mutate a read-only list");
        }
    }

    private final void check(E e) {
        if (this._checker != null) {
            this._checker.check(this, e);
        }
    }

    private final void checkAll(Collection<? extends E> c) {
        if (this._checker != null) {
            for (E e : c) {
                this._checker.check(this, e);
            }
        }
    }

    private boolean assertCheck(E e) {
        try {
            this.check(e);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    protected final List<E> getObject() {
        return this._list;
    }

    private static class InternalList<E>
    extends ArrayList<E> {
        public InternalList() {
        }

        public InternalList(List<? extends E> l) {
            super(l);
        }

        public InternalList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }
    }
}

