/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.message;

import com.linkedin.data.element.DataElement;
import java.io.IOException;
import java.util.Formatter;

public class Message {
    public static final String MESSAGE_FIELD_SEPARATOR = " :: ";
    private final Object[] _path;
    private final boolean _error;
    private final String _format;
    private final Object[] _args;

    public Message(Object[] path, String format, Object ... args) {
        this(path, true, format, args);
    }

    public Message(Object[] path, boolean error, String format, Object ... args) {
        this._path = path;
        this._error = error;
        this._format = format;
        this._args = args;
    }

    public Object[] getPath() {
        return this._path;
    }

    public String getFormat() {
        return this._format;
    }

    public Object[] getArgs() {
        return this._args;
    }

    public boolean isError() {
        return this._error;
    }

    public Message asErrorMessage() {
        return this._error ? this : new Message(this._path, true, this._format, this._args);
    }

    public Message asInfoMessage() {
        return this._error ? new Message(this._path, false, this._format, this._args) : this;
    }

    public Formatter format(Formatter formatter, String fieldSeparator) {
        this.formatError(formatter);
        this.formatSeparator(formatter, fieldSeparator);
        this.formatPath(formatter);
        this.formatSeparator(formatter, fieldSeparator);
        this.formatArgs(formatter);
        return formatter;
    }

    protected void formatSeparator(Formatter formatter, String fieldSeparator) {
        try {
            Appendable out = formatter.out();
            out.append(fieldSeparator);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void formatError(Formatter formatter) {
        formatter.format(this.isError() ? "ERROR" : "INFO", new Object[0]);
    }

    protected void formatPath(Formatter formatter) {
        Appendable appendable = formatter.out();
        try {
            for (Object component : this._path) {
                appendable.append(DataElement.SEPARATOR.charValue());
                appendable.append(component.toString());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void formatArgs(Formatter formatter) {
        formatter.format(this._format, this._args);
    }

    public Formatter format(Formatter formatter) {
        return this.format(formatter, this.getFieldSeparator());
    }

    public String getFieldSeparator() {
        return MESSAGE_FIELD_SEPARATOR;
    }

    public String toString() {
        String fieldSeparator = this.getFieldSeparator();
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        this.format(formatter, fieldSeparator);
        formatter.flush();
        formatter.close();
        return sb.toString();
    }
}

