/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.generator;

import com.linkedin.data.Data;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PegasusSchemaParser;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaParser;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.generator.DataGenerator;
import com.linkedin.data.schema.generator.DefaultSampleDataCallback;
import com.linkedin.data.schema.generator.SampleDataCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class SchemaSampleDataGenerator
implements DataGenerator {
    private static final int MAX_ALLOWED_SCHEMA_RECURSION = 5;
    private final DataGenerationOptions _spec;
    private final PegasusSchemaParser _schemaParser;
    private static final Random _random = new Random();

    public static DataMap buildRecordData(NamedDataSchema schema, DataGenerationOptions spec) {
        return SchemaSampleDataGenerator.buildRecordData(new ParentSchemas(), schema, spec);
    }

    public static Object buildData(DataSchema schema, DataGenerationOptions spec) {
        return SchemaSampleDataGenerator.buildData(new ParentSchemas(), schema, null, spec);
    }

    public static Object buildData(DataSchema schema, String fieldName, DataGenerationOptions spec) {
        return SchemaSampleDataGenerator.buildData(new ParentSchemas(), schema, fieldName, spec);
    }

    private static DataMap buildRecordData(ParentSchemas parentSchemas, NamedDataSchema schema, DataGenerationOptions spec) {
        spec = SchemaSampleDataGenerator.preventRecursionIntoAlreadyTraversedSchemas(parentSchemas, spec, schema);
        parentSchemas.incrementReferences(schema);
        DataMap data = new DataMap();
        if (schema instanceof RecordDataSchema) {
            for (RecordDataSchema.Field field : ((RecordDataSchema)schema).getFields()) {
                if (spec.isRequiredFieldsOnly() && field.getOptional()) continue;
                Object value = spec.isUseDefaults() && field.getDefault() != null ? field.getDefault() : SchemaSampleDataGenerator.buildData(parentSchemas, field.getType(), field.getName(), spec);
                if (value == null) {
                    data.remove(field.getName());
                    continue;
                }
                data.put(field.getName(), value);
            }
        } else if (schema instanceof TyperefDataSchema) {
            data.put("ref", SchemaSampleDataGenerator.buildData(parentSchemas, schema.getDereferencedDataSchema(), spec));
        } else {
            data.put("value", SchemaSampleDataGenerator.buildData(parentSchemas, schema, spec));
        }
        parentSchemas.decrementReferences(schema);
        return data;
    }

    private static Object buildData(ParentSchemas parentSchemas, DataSchema schema, DataGenerationOptions spec) {
        return SchemaSampleDataGenerator.buildData(parentSchemas, schema, null, spec);
    }

    private static Object buildData(ParentSchemas parentSchemas, DataSchema schema, String fieldName, DataGenerationOptions spec) {
        spec = SchemaSampleDataGenerator.preventRecursionIntoAlreadyTraversedSchemas(parentSchemas, spec, schema);
        parentSchemas.incrementReferences(schema);
        DataSchema derefSchema = schema.getDereferencedDataSchema();
        SampleDataCallback callback = spec.getCallback();
        Object data = null;
        switch (derefSchema.getType()) {
            case BOOLEAN: {
                data = callback.getBoolean(fieldName);
                break;
            }
            case INT: {
                data = callback.getInteger(fieldName);
                break;
            }
            case LONG: {
                data = callback.getLong(fieldName);
                break;
            }
            case FLOAT: {
                data = Float.valueOf(callback.getFloat(fieldName));
                break;
            }
            case DOUBLE: {
                data = callback.getDouble(fieldName);
                break;
            }
            case BYTES: {
                data = callback.getBytes(fieldName);
                break;
            }
            case STRING: {
                data = callback.getString(fieldName);
                break;
            }
            case NULL: {
                data = Data.NULL;
                break;
            }
            case FIXED: {
                data = callback.getFixed(fieldName, (FixedDataSchema)derefSchema);
                break;
            }
            case ENUM: {
                data = callback.getEnum(fieldName, (EnumDataSchema)derefSchema);
                break;
            }
            case ARRAY: {
                DataList dataList = new DataList(spec.getArraySize());
                for (int i = 0; i < spec.getArraySize(); ++i) {
                    Object item = SchemaSampleDataGenerator.buildData(parentSchemas, ((ArrayDataSchema)derefSchema).getItems(), fieldName, spec);
                    dataList.add(item);
                }
                data = dataList;
                break;
            }
            case RECORD: {
                data = SchemaSampleDataGenerator.buildRecordData(parentSchemas, (RecordDataSchema)derefSchema, spec);
                break;
            }
            case MAP: {
                DataMap dataMap = new DataMap();
                for (int i = 0; i < spec.getArraySize(); ++i) {
                    Object item = SchemaSampleDataGenerator.buildData(parentSchemas, ((MapDataSchema)derefSchema).getValues(), fieldName, spec);
                    dataMap.put("mapField_" + _random.nextInt(), item);
                }
                data = dataMap;
                break;
            }
            case UNION: {
                UnionDataSchema unionSchema = (UnionDataSchema)derefSchema;
                List<DataSchema> types = SchemaSampleDataGenerator.removeAlreadyTraversedSchemasFromUnionMemberList(parentSchemas, unionSchema.getTypes());
                int unionIndex = _random.nextInt(types.size());
                DataSchema unionItemSchema = types.get(unionIndex);
                data = SchemaSampleDataGenerator.buildData(parentSchemas, unionItemSchema, fieldName, spec);
                if (data == null) break;
                DataMap unionMap = new DataMap();
                unionMap.put(unionItemSchema.getUnionMemberKey(), data);
                data = unionMap;
                break;
            }
            case TYPEREF: {
                data = SchemaSampleDataGenerator.buildData(parentSchemas, derefSchema, fieldName, spec);
            }
        }
        parentSchemas.decrementReferences(schema);
        return data;
    }

    public SchemaSampleDataGenerator(DataSchemaResolver resolver, DataGenerationOptions spec) {
        this._schemaParser = new SchemaParser(resolver);
        this._spec = spec;
    }

    @Override
    public Object buildData(String fieldName, DataSchema dataSchema) {
        return SchemaSampleDataGenerator.buildData(dataSchema, fieldName, this._spec);
    }

    private DataMap buildDataMap(ParentSchemas parentSchemas, String pegasusDataSchemaName, DataGenerationOptions spec) {
        DataSchema schema = this._schemaParser.lookupName(pegasusDataSchemaName);
        spec = SchemaSampleDataGenerator.preventRecursionIntoAlreadyTraversedSchemas(parentSchemas, spec, schema);
        parentSchemas.incrementReferences(schema);
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Could not find pegasus data schema '%s'", pegasusDataSchemaName));
        }
        assert (schema instanceof RecordDataSchema);
        DataMap data = SchemaSampleDataGenerator.buildRecordData(parentSchemas, (RecordDataSchema)schema, spec);
        parentSchemas.decrementReferences(schema);
        return data;
    }

    private static DataGenerationOptions preventRecursionIntoAlreadyTraversedSchemas(ParentSchemas parentSchemas, DataGenerationOptions spec, DataSchema schema) {
        if (parentSchemas.count(schema) > 5) {
            throw new IllegalArgumentException("Could not generate data for recursively referenced schemas. Recursive referenced schemas must be optional or in a list, map or union with valid alternatives.");
        }
        if (parentSchemas.contains(schema)) {
            spec = spec.getConstrained();
        }
        return spec;
    }

    private static List<DataSchema> removeAlreadyTraversedSchemasFromUnionMemberList(ParentSchemas parentSchemas, List<DataSchema> unionMembers) {
        ArrayList<DataSchema> copy = new ArrayList<DataSchema>(unionMembers);
        copy.removeAll(parentSchemas.getAllReferenced());
        if (copy.isEmpty()) {
            return unionMembers;
        }
        return copy;
    }

    private static class ParentSchemas {
        private final Map<DataSchema, Integer> counts = new HashMap<DataSchema, Integer>();

        private ParentSchemas() {
        }

        public void incrementReferences(DataSchema schema) {
            Integer count = this.counts.get(schema);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            this.counts.put(schema, count);
        }

        public void decrementReferences(DataSchema schema) {
            Integer count = this.counts.get(schema);
            if (count == null || count == 0) {
                throw new IllegalArgumentException("No references to remove for given schema");
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count - 1);
            if (count == 0) {
                this.counts.remove(schema);
            } else {
                this.counts.put(schema, count);
            }
        }

        public int count(DataSchema schema) {
            Integer count = this.counts.get(schema);
            if (count == null) {
                count = 0;
            }
            return count;
        }

        public boolean contains(DataSchema schema) {
            return this.count(schema) > 0;
        }

        public Set<DataSchema> getAllReferenced() {
            return this.counts.keySet();
        }
    }

    public static class DataGenerationOptions
    implements Cloneable {
        private boolean _requiredFieldsOnly = false;
        private boolean _useDefaults = false;
        private int _arraySize = (int)(Math.random() * 3.0) + 1;
        private SampleDataCallback _callback = DefaultSampleDataCallback.INSTANCE;

        public DataGenerationOptions clone() {
            try {
                return (DataGenerationOptions)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e);
            }
        }

        public DataGenerationOptions getConstrained() {
            DataGenerationOptions constrained = this.clone();
            constrained._requiredFieldsOnly = true;
            constrained._arraySize = 0;
            return constrained;
        }

        public boolean isRequiredFieldsOnly() {
            return this._requiredFieldsOnly;
        }

        public void setRequiredFieldsOnly(boolean requiredFieldsOnly) {
            this._requiredFieldsOnly = requiredFieldsOnly;
        }

        public boolean isUseDefaults() {
            return this._useDefaults;
        }

        public void setUseDefaults(boolean useDefaults) {
            this._useDefaults = useDefaults;
        }

        public int getArraySize() {
            return this._arraySize;
        }

        public void setArraySize(int arraySize) {
            this._arraySize = arraySize;
        }

        public SampleDataCallback getCallback() {
            return this._callback;
        }

        public void setCallback(SampleDataCallback pool) {
            this._callback = pool;
        }
    }
}

