/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.resolver;

import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.SchemaParserFactory;
import com.linkedin.data.schema.resolver.DefaultDataSchemaResolver;
import com.linkedin.data.schema.resolver.FileDataSchemaLocation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ClasspathResourceDataSchemaResolver
extends DefaultDataSchemaResolver {
    private static final String DIR_IN_JAR = "pegasus";
    public static final String DEFAULT_EXTENSION = ".pdsc";
    private final ClassLoader _classLoader;

    public ClasspathResourceDataSchemaResolver(SchemaParserFactory parserFactory) {
        super(parserFactory);
        this._classLoader = Thread.currentThread().getContextClassLoader();
    }

    public ClasspathResourceDataSchemaResolver(SchemaParserFactory parserFactory, ClassLoader classLoader) {
        super(parserFactory);
        this._classLoader = classLoader;
    }

    private String getDataSchemaResourcePath(String schemaName) {
        return "pegasus/" + schemaName.replace('.', '/') + DEFAULT_EXTENSION;
    }

    @Override
    protected NamedDataSchema locateDataSchema(String schemaName, StringBuilder errorMessageBuilder) {
        NamedDataSchema schema = null;
        String schemaResourcePath = this.getDataSchemaResourcePath(schemaName);
        try (InputStream stream = this._classLoader.getResourceAsStream(schemaResourcePath);){
            if (stream == null) {
                errorMessageBuilder.append(String.format("Unable to find data schema file \"%s\" in classpath.", schemaResourcePath));
            } else {
                FileDataSchemaLocation location = new FileDataSchemaLocation(new File(schemaResourcePath));
                schema = this.parse(stream, location, schemaName, errorMessageBuilder);
            }
        }
        catch (IOException e) {
            errorMessageBuilder.append(String.format("Failed to read/close data schema file \"%s\" in classpath: \"%s\"", schemaResourcePath, e.getMessage()));
        }
        return schema;
    }
}

