/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.resolver;

import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaParserFactory;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.SchemaParserFactory;
import com.linkedin.data.schema.grammar.PdlSchemaParserFactory;
import com.linkedin.data.schema.resolver.FileDataSchemaResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiFormatDataSchemaResolver
implements DataSchemaResolver {
    public static final String[] BUILTIN_EXTENSIONS = new String[]{".pdsc", ".pdl"};
    private final List<DataSchemaResolver> resolvers = new ArrayList<DataSchemaResolver>();
    public static List<DataSchemaParserFactory> BUILTIN_FORMAT_PARSER_FACTORIES = new ArrayList<DataSchemaParserFactory>(2);

    public static MultiFormatDataSchemaResolver withBuiltinFormats(String resolverPath) {
        return new MultiFormatDataSchemaResolver(resolverPath, BUILTIN_FORMAT_PARSER_FACTORIES);
    }

    public MultiFormatDataSchemaResolver(String resolverPath, List<DataSchemaParserFactory> parsersForFormats) {
        for (DataSchemaParserFactory parserForFormat : parsersForFormats) {
            FileDataSchemaResolver resolver = new FileDataSchemaResolver(parserForFormat, resolverPath, this);
            resolver.setExtension("." + parserForFormat.getLanguageExtension());
            this.resolvers.add(resolver);
        }
    }

    @Override
    public Map<String, NamedDataSchema> bindings() {
        HashMap<String, NamedDataSchema> results = new HashMap<String, NamedDataSchema>();
        for (DataSchemaResolver resolver : this.resolvers) {
            results.putAll(resolver.bindings());
        }
        return results;
    }

    @Override
    public Map<String, DataSchemaLocation> nameToDataSchemaLocations() {
        HashMap<String, DataSchemaLocation> results = new HashMap<String, DataSchemaLocation>();
        for (DataSchemaResolver resolver : this.resolvers) {
            results.putAll(resolver.nameToDataSchemaLocations());
        }
        return results;
    }

    @Override
    public NamedDataSchema findDataSchema(String name, StringBuilder errorMessageBuilder) {
        for (DataSchemaResolver resolver : this.resolvers) {
            NamedDataSchema result = resolver.findDataSchema(name, errorMessageBuilder);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void bindNameToSchema(Name name, NamedDataSchema schema, DataSchemaLocation location) {
        for (DataSchemaResolver resolver : this.resolvers) {
            resolver.bindNameToSchema(name, schema, location);
        }
    }

    @Override
    public NamedDataSchema existingDataSchema(String name) {
        for (DataSchemaResolver resolver : this.resolvers) {
            NamedDataSchema result = resolver.existingDataSchema(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean locationResolved(DataSchemaLocation location) {
        for (DataSchemaResolver resolver : this.resolvers) {
            if (!resolver.locationResolved(location)) continue;
            return true;
        }
        return false;
    }

    static {
        BUILTIN_FORMAT_PARSER_FACTORIES.add(SchemaParserFactory.instance());
        BUILTIN_FORMAT_PARSER_FACTORIES.add(PdlSchemaParserFactory.instance());
    }
}

