/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.validation;

import com.linkedin.data.ByteString;
import com.linkedin.data.Data;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.Null;
import com.linkedin.data.element.DataElement;
import com.linkedin.data.element.MutableDataElement;
import com.linkedin.data.element.SimpleDataElement;
import com.linkedin.data.it.IterationOrder;
import com.linkedin.data.it.ObjectIterator;
import com.linkedin.data.message.Message;
import com.linkedin.data.message.MessageList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.BytesDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.validation.CoercionMode;
import com.linkedin.data.schema.validation.RequiredMode;
import com.linkedin.data.schema.validation.UnrecognizedFieldMode;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.schema.validation.ValidationResult;
import com.linkedin.data.schema.validator.Validator;
import com.linkedin.data.schema.validator.ValidatorContext;
import com.linkedin.data.template.DataTemplate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ValidateDataAgainstSchema {
    private static final HashMap<DataSchema.Type, Class<?>> _primitiveTypeToClassMap = new HashMap<DataSchema.Type, Class<?>>(){
        {
            this.put(DataSchema.Type.INT, Integer.class);
            this.put(DataSchema.Type.LONG, Long.class);
            this.put(DataSchema.Type.FLOAT, Float.class);
            this.put(DataSchema.Type.DOUBLE, Double.class);
            this.put(DataSchema.Type.STRING, String.class);
            this.put(DataSchema.Type.BOOLEAN, Boolean.class);
            this.put(DataSchema.Type.NULL, Null.class);
        }
    };

    private ValidateDataAgainstSchema() {
    }

    public static ValidationResult validate(DataTemplate<?> dataTemplate, ValidationOptions options) {
        return ValidateDataAgainstSchema.validate(dataTemplate, options, null);
    }

    public static ValidationResult validate(DataTemplate<?> dataTemplate, ValidationOptions options, Validator validator) {
        if (dataTemplate.schema() == null) {
            return new State(options, validator);
        }
        return ValidateDataAgainstSchema.validate(dataTemplate.data(), dataTemplate.schema(), options, validator);
    }

    public static ValidationResult validate(Object object, DataSchema schema, ValidationOptions options) {
        return ValidateDataAgainstSchema.validate(object, schema, options, null);
    }

    public static ValidationResult validate(Object object, DataSchema schema, ValidationOptions options, Validator validator) {
        return ValidateDataAgainstSchema.validate(new SimpleDataElement(object, schema), options, validator);
    }

    public static ValidationResult validate(DataElement element, ValidationOptions options) {
        return ValidateDataAgainstSchema.validate(element, options, null);
    }

    public static ValidationResult validate(DataElement element, ValidationOptions options, Validator validator) {
        State state = new State(options, validator);
        state.validate(element);
        return state;
    }

    private static class State
    implements ValidationResult {
        private boolean _recursive;
        private final ValidationOptions _options;
        private final Validator _validator;
        private boolean _hasFix = false;
        private boolean _hasFixupReadOnlyError = false;
        private Object _fixed = null;
        private boolean _valid = true;
        private final Context _context;
        private List<FieldToTrim> _toTrim = new ArrayList<FieldToTrim>(0);
        private MessageList<Message> _messages = new MessageList();

        private State(ValidationOptions options, Validator validator) {
            this._options = options;
            this._validator = validator;
            this._context = validator == null ? null : new Context();
        }

        protected void validate(DataElement element) {
            if (this._options.isAvroUnionMode()) {
                this.validateRecursive(element);
            } else {
                this.validateIterative(element);
            }
            if (this._toTrim.size() > 0) {
                for (FieldToTrim fieldToTrim : this._toTrim) {
                    fieldToTrim.trim();
                }
            }
        }

        protected void validateRecursive(DataElement element) {
            this._recursive = true;
            this._fixed = this.validate(element, element.getSchema(), element.getValue());
        }

        protected void validateIterative(DataElement element) {
            DataElement nextElement;
            this._recursive = false;
            this._fixed = element.getValue();
            UnrecognizedFieldMode unrecognizedFieldMode = this._options.getUnrecognizedFieldMode();
            ObjectIterator it = new ObjectIterator(element, IterationOrder.POST_ORDER);
            while ((nextElement = it.next()) != null) {
                DataElement parentElement;
                DataSchema nextElementSchema = nextElement.getSchema();
                if (nextElementSchema != null) {
                    this.validate(nextElement, nextElementSchema, nextElement.getValue());
                    continue;
                }
                if (unrecognizedFieldMode == UnrecognizedFieldMode.IGNORE || (parentElement = nextElement.getParent()) == null || parentElement.getSchema() == null) continue;
                this.handleUnrecognizedField(nextElement);
            }
        }

        protected Object validate(DataElement element, DataSchema schema, Object object) {
            Object fixed;
            switch (schema.getType()) {
                case ARRAY: {
                    fixed = this.validateArray(element, (ArrayDataSchema)schema, object);
                    break;
                }
                case BYTES: {
                    fixed = this.validateBytes(element, (BytesDataSchema)schema, object);
                    break;
                }
                case ENUM: {
                    fixed = this.validateEnum(element, (EnumDataSchema)schema, object);
                    break;
                }
                case FIXED: {
                    fixed = this.validateFixed(element, (FixedDataSchema)schema, object);
                    break;
                }
                case MAP: {
                    fixed = this.validateMap(element, (MapDataSchema)schema, object);
                    break;
                }
                case RECORD: {
                    fixed = this.validateRecord(element, (RecordDataSchema)schema, object);
                    break;
                }
                case TYPEREF: {
                    fixed = this.validateTyperef(element, (TyperefDataSchema)schema, object);
                    break;
                }
                case UNION: {
                    fixed = this.validateUnion(element, (UnionDataSchema)schema, object);
                    break;
                }
                default: {
                    fixed = this.validatePrimitive(element, schema, object);
                }
            }
            if (fixed != object) {
                this.fixValue(element, fixed);
            }
            if (this._validator != null && element.getSchema() == schema) {
                DataElement validatorElement;
                if (fixed == object) {
                    validatorElement = element;
                } else if (element instanceof MutableDataElement) {
                    ((MutableDataElement)element).setValue(fixed);
                    validatorElement = element;
                } else {
                    validatorElement = new SimpleDataElement(fixed, element.getName(), schema, element.getParent());
                }
                this._context._dataElement = validatorElement;
                this._validator.validate(this._context);
            }
            return fixed;
        }

        protected void fixValue(DataElement element, Object fixed) {
            assert (this._options.getCoercionMode() != CoercionMode.OFF);
            this._hasFix = true;
            DataElement parentElement = element.getParent();
            if (parentElement == null) {
                this._fixed = fixed;
            } else {
                Object parent = parentElement.getValue();
                if (parent.getClass() == DataMap.class) {
                    DataMap map = (DataMap)parent;
                    if (map.isReadOnly()) {
                        this._hasFixupReadOnlyError = true;
                        this.addMessage(element, "cannot be fixed because DataMap backing %1$s type is read-only", parentElement.getSchema().getUnionMemberKey());
                    } else {
                        map.put((String)element.getName(), fixed);
                    }
                } else if (parent.getClass() == DataList.class) {
                    DataList list = (DataList)parent;
                    if (list.isReadOnly()) {
                        this._hasFixupReadOnlyError = true;
                        this.addMessage(element, "cannot be fixed because DataList backing an array type is read-only", new Object[0]);
                    } else {
                        list.set((Integer)element.getName(), fixed);
                    }
                }
            }
        }

        protected Object validateTyperef(DataElement element, TyperefDataSchema schema, Object object) {
            return this.validate(element, schema.getRef(), object);
        }

        protected void recurseRecord(DataElement element, RecordDataSchema schema, DataMap map) {
            MutableDataElement childElement = new MutableDataElement(element);
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                RecordDataSchema.Field field = schema.getField(key);
                Object value = entry.getValue();
                if (field != null) {
                    DataSchema childSchema = field.getType();
                    childElement.setValueNameSchema(value, key, childSchema);
                    this.validate(childElement, childSchema, value);
                    continue;
                }
                childElement.setValueNameSchema(value, key, null);
                this.handleUnrecognizedField(childElement);
            }
        }

        private void trimUnrecognizedField(DataElement element) {
            DataElement parentElement = element.getParent();
            Object parent = parentElement.getValue();
            if (parent != null && parent.getClass() == DataMap.class) {
                DataMap map = (DataMap)parent;
                Object name = element.getName();
                assert (name instanceof String);
                String fieldName = (String)name;
                if (map.isReadOnly()) {
                    this._hasFixupReadOnlyError = true;
                    this.addMessage(element, "unrecognized field cannot be trimmed because DataMap backing it is read-only", new Object[0]);
                } else {
                    this._toTrim.add(new FieldToTrim(map, fieldName));
                }
            }
        }

        private void handleUnrecognizedField(DataElement element) {
            switch (this._options.getUnrecognizedFieldMode()) {
                case IGNORE: {
                    break;
                }
                case DISALLOW: {
                    this.addMessage(element, "unrecognized field found but not allowed", new Object[0]);
                    break;
                }
                case TRIM: {
                    this.trimUnrecognizedField(element);
                }
            }
        }

        private boolean isFieldOptional(RecordDataSchema.Field field, DataElement element) {
            if (field.getOptional()) {
                return true;
            }
            return this._options.getTreatOptional().evaluate(new SimpleDataElement(null, field.getName(), field.getType(), element));
        }

        protected Object validateRecord(DataElement element, RecordDataSchema schema, Object object) {
            if (object instanceof DataMap) {
                RequiredMode requiredMode;
                DataMap map = (DataMap)object;
                if (this._recursive) {
                    this.recurseRecord(element, schema, map);
                }
                if ((requiredMode = this._options.getRequiredMode()) != RequiredMode.IGNORE) {
                    for (RecordDataSchema.Field field : schema.getFields()) {
                        if (this.isFieldOptional(field, element) || map.containsKey(field.getName())) continue;
                        switch (requiredMode) {
                            case MUST_BE_PRESENT: {
                                this.addIsRequiredMessage(element, field, "field is required but not found");
                                break;
                            }
                            case CAN_BE_ABSENT_IF_HAS_DEFAULT: {
                                if (field.getDefault() != null) break;
                                this.addIsRequiredMessage(element, field, "field is required but not found and has no default value");
                                break;
                            }
                            case FIXUP_ABSENT_WITH_DEFAULT: {
                                Object defaultValue = field.getDefault();
                                if (defaultValue == null) {
                                    this.addIsRequiredMessage(element, field, "field is required but not found and has no default value");
                                    break;
                                }
                                if (map.isReadOnly()) {
                                    this._hasFix = true;
                                    this._hasFixupReadOnlyError = true;
                                    this.addIsRequiredMessage(element, field, "field is required and has default value but not found and cannot be fixed because DataMap of record is read-only");
                                    break;
                                }
                                this._hasFix = true;
                                map.put(field.getName(), defaultValue);
                            }
                        }
                    }
                }
            } else {
                this.addMessage(element, "record type is not backed by a DataMap", new Object[0]);
            }
            return object;
        }

        protected Object validateUnion(DataElement element, UnionDataSchema schema, Object object) {
            if (object == Data.NULL) {
                if (schema.getType("null") == null) {
                    this.addMessage(element, "null is not a member type of union %1$s", schema);
                }
            } else if (this._options.isAvroUnionMode()) {
                List<DataSchema> memberTypes = schema.getTypes();
                if (memberTypes.isEmpty()) {
                    this.addMessage(element, "value %1$s is not valid for empty union", object.toString());
                } else {
                    DataSchema memberSchema = memberTypes.get(0);
                    assert (this._recursive);
                    this.validate(element, memberSchema, object);
                }
            } else if (object instanceof DataMap) {
                DataMap map = (DataMap)object;
                if (map.size() != 1) {
                    this.addMessage(element, "DataMap should have exactly one entry for a union type", new Object[0]);
                } else {
                    Map.Entry entry = map.entrySet().iterator().next();
                    String key = (String)entry.getKey();
                    DataSchema memberSchema = schema.getType(key);
                    if (memberSchema == null) {
                        this.addMessage(element, "\"%1$s\" is not a member type of union %2$s", key, schema);
                    } else if (this._recursive) {
                        Object value = entry.getValue();
                        MutableDataElement memberElement = new MutableDataElement(value, key, memberSchema, element);
                        this.validate(memberElement, memberSchema, value);
                    }
                }
            } else {
                this.addMessage(element, "union type is not backed by a DataMap or null", new Object[0]);
            }
            return object;
        }

        protected Object validateEnum(DataElement element, EnumDataSchema schema, Object object) {
            Object fixed = object;
            if (object instanceof String) {
                String value = (String)object;
                if (!schema.contains(value)) {
                    this.addMessage(element, "\"%1$s\" is not an enum symbol", value);
                }
            } else {
                this.addMessage(element, "enum type is not backed by a String", new Object[0]);
            }
            return fixed;
        }

        protected void recurseArray(DataElement element, ArrayDataSchema schema, Object object) {
            DataList list = (DataList)object;
            DataSchema childSchema = schema.getItems();
            int index = 0;
            MutableDataElement childElement = new MutableDataElement(element);
            for (Object value : list) {
                childElement.setValueNameSchema(value, index, childSchema);
                this.validate(childElement, childSchema, value);
                ++index;
            }
        }

        protected Object validateArray(DataElement element, ArrayDataSchema schema, Object object) {
            if (object instanceof DataList) {
                if (this._recursive) {
                    this.recurseArray(element, schema, object);
                }
            } else {
                this.addMessage(element, "array type is not backed by a DataList", new Object[0]);
            }
            return object;
        }

        protected void recurseMap(DataElement element, MapDataSchema schema, Object object) {
            DataMap map = (DataMap)object;
            DataSchema childSchema = schema.getValues();
            MutableDataElement childElement = new MutableDataElement(element);
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                childElement.setValueNameSchema(value, key, childSchema);
                this.validate(childElement, childSchema, value);
            }
        }

        protected Object validateMap(DataElement element, MapDataSchema schema, Object object) {
            if (object instanceof DataMap) {
                if (this._recursive) {
                    this.recurseMap(element, schema, object);
                }
            } else {
                this.addMessage(element, "map type is not backed by a DataMap", new Object[0]);
            }
            return object;
        }

        protected Object validateFixed(DataElement element, FixedDataSchema schema, Object object) {
            Object fixed = object;
            Class<?> clazz = object.getClass();
            int size = schema.getSize();
            if (clazz == String.class) {
                String str = (String)object;
                boolean error = false;
                if (str.length() != size) {
                    this.addMessage(element, "\"%1$s\" length (%2$d) is inconsistent with expected fixed size of %3$d", str, str.length(), size);
                } else if (this._options.getCoercionMode() != CoercionMode.OFF) {
                    ByteString bytes = ByteString.copyAvroString(str, true);
                    if (bytes != null) {
                        this._hasFix = true;
                        fixed = bytes;
                    } else {
                        error = true;
                    }
                } else {
                    boolean bl = error = !Data.validStringAsBytes(str);
                }
                if (error) {
                    this.addMessage(element, "\"%1$s\" is not a valid string representation of bytes", str);
                }
            } else if (clazz == ByteString.class) {
                ByteString bytes = (ByteString)object;
                if (bytes.length() != size) {
                    this.addMessage(element, "\"%1$s\" length (%2$d) is inconsistent with expected fixed size of %3$d", bytes, bytes.length(), size);
                }
            } else {
                this.addMessage(element, "fixed type is not backed by a String or ByteString", new Object[0]);
            }
            return fixed;
        }

        protected Object validateBytes(DataElement element, BytesDataSchema schema, Object object) {
            Object fixed = object;
            Class<?> clazz = object.getClass();
            if (clazz == String.class) {
                String str = (String)object;
                boolean error = false;
                if (this._options.getCoercionMode() != CoercionMode.OFF) {
                    ByteString bytes = ByteString.copyAvroString(str, true);
                    if (bytes != null) {
                        this._hasFix = true;
                        fixed = bytes;
                    } else {
                        error = true;
                    }
                } else {
                    boolean bl = error = !Data.validStringAsBytes(str);
                }
                if (error) {
                    this.addMessage(element, "\"%1$s\" is not a valid string representation of bytes", str);
                }
            } else if (clazz != ByteString.class) {
                this.addMessage(element, "bytes type is not backed by a String or ByteString", new Object[0]);
            }
            return fixed;
        }

        protected Object validatePrimitive(DataElement element, DataSchema schema, Object object) {
            Class primitiveClass = (Class)_primitiveTypeToClassMap.get((Object)schema.getType());
            Object fixed = object;
            if (object.getClass() != primitiveClass) {
                if (this._options.getCoercionMode() != CoercionMode.OFF) {
                    fixed = this.fixupPrimitive(schema, object);
                    if (fixed == object) {
                        this.addMessage(element, "%1$s cannot be coerced to %2$s", String.valueOf(object), primitiveClass.getSimpleName());
                    }
                } else {
                    this.addMessage(element, "%1$s is not backed by a %2$s", String.valueOf(object), primitiveClass.getSimpleName());
                }
            }
            return fixed;
        }

        protected Object fixupPrimitive(DataSchema schema, Object object) {
            DataSchema.Type schemaType = schema.getType();
            try {
                switch (schemaType) {
                    case INT: {
                        return object instanceof Number ? Integer.valueOf(((Number)object).intValue()) : (object.getClass() == String.class && this._options.getCoercionMode() == CoercionMode.STRING_TO_PRIMITIVE ? Integer.valueOf(new BigDecimal((String)object).intValue()) : object);
                    }
                    case LONG: {
                        return object instanceof Number ? Long.valueOf(((Number)object).longValue()) : (object.getClass() == String.class && this._options.getCoercionMode() == CoercionMode.STRING_TO_PRIMITIVE ? Long.valueOf(new BigDecimal((String)object).longValue()) : object);
                    }
                    case FLOAT: {
                        return object instanceof Number ? Float.valueOf(((Number)object).floatValue()) : (object.getClass() == String.class && this._options.getCoercionMode() == CoercionMode.STRING_TO_PRIMITIVE ? Float.valueOf(new BigDecimal((String)object).floatValue()) : object);
                    }
                    case DOUBLE: {
                        return object instanceof Number ? Double.valueOf(((Number)object).doubleValue()) : (object.getClass() == String.class && this._options.getCoercionMode() == CoercionMode.STRING_TO_PRIMITIVE ? Double.valueOf(new BigDecimal((String)object).doubleValue()) : object);
                    }
                    case BOOLEAN: {
                        if (object.getClass() == String.class && this._options.getCoercionMode() == CoercionMode.STRING_TO_PRIMITIVE) {
                            String string = (String)object;
                            if ("true".equalsIgnoreCase(string)) {
                                return Boolean.TRUE;
                            }
                            if ("false".equalsIgnoreCase(string)) {
                                return Boolean.FALSE;
                            }
                        }
                        return object;
                    }
                }
                return object;
            }
            catch (NumberFormatException exc) {
                return object;
            }
        }

        protected void addMessage(DataElement element, String format, Object ... args) {
            this._messages.add(new Message(element.path(), format, args));
            this._valid = false;
        }

        protected void addIsRequiredMessage(DataElement element, RecordDataSchema.Field field, String msg) {
            this._messages.add(new Message(element.path(field.getName()), msg, new Object[0]));
            this._valid = false;
        }

        @Override
        public boolean hasFix() {
            return this._hasFix;
        }

        @Override
        public boolean hasFixupReadOnlyError() {
            return this._hasFixupReadOnlyError;
        }

        @Override
        public Object getFixed() {
            return this._fixed;
        }

        @Override
        public boolean isValid() {
            return this._valid;
        }

        @Override
        public Collection<Message> getMessages() {
            return Collections.unmodifiableList(this._messages);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("hasFix=").append(this._hasFix).append(", hasFixupReadOnlyError=").append(this._hasFixupReadOnlyError).append(", valid=").append(this._valid).append("\n").append("fixed=").append(this._fixed).append("\n");
            this._messages.appendTo(sb);
            return sb.toString();
        }

        private class Context
        implements ValidatorContext {
            private DataElement _dataElement;

            private Context() {
            }

            @Override
            public DataElement dataElement() {
                return this._dataElement;
            }

            @Override
            public void addResult(Message message) {
                State.this._messages.add(message);
                if (message.isError()) {
                    State.this._valid = false;
                }
            }

            @Override
            public void setHasFix(boolean value) {
                State.this._hasFix = value;
            }

            @Override
            public void setHasFixupReadOnlyError(boolean value) {
                State.this._hasFixupReadOnlyError = value;
            }

            @Override
            public ValidationOptions validationOptions() {
                return State.this._options;
            }
        }

        private static class FieldToTrim {
            private DataMap _parent;
            private String _fieldName;

            private FieldToTrim(DataMap parent, String fieldName) {
                assert (!parent.isReadOnly());
                this._parent = parent;
                this._fieldName = fieldName;
            }

            private void trim() {
                if (this._parent.isReadOnly()) {
                    throw new ConcurrentModificationException("Map marked as read-only during validation.");
                }
                this._parent.remove(this._fieldName);
            }
        }
    }
}

