/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.FieldDef;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DynamicRecordTemplate
extends RecordTemplate {
    public DynamicRecordTemplate(DataMap data, RecordDataSchema schema) {
        super(data, schema);
    }

    public DynamicRecordTemplate(RecordDataSchema schema) {
        super(new DataMap(), schema);
    }

    public DynamicRecordTemplate(RecordDataSchema schema, Map<FieldDef<?>, Object> fieldDefValues) {
        this(schema);
        for (Map.Entry<FieldDef<?>, Object> entry : fieldDefValues.entrySet()) {
            this.setValue(entry.getKey(), entry.getValue());
        }
    }

    public <T> T getValue(FieldDef<T> fieldDef) {
        if (fieldDef == null) {
            return null;
        }
        RecordDataSchema.Field field = fieldDef.getField();
        if (!this.fieldDefInRecord(fieldDef)) {
            throw new IllegalArgumentException("Field " + fieldDef.getName() + " is not a field belonging to the schema of this DynamicRecordTemplate.");
        }
        if (fieldDef.getType().isArray()) {
            return this.obtainArray(field, fieldDef);
        }
        if (DataTemplate.class.isAssignableFrom(fieldDef.getType())) {
            return (T)this.obtainWrapped(field, fieldDef.getType(), GetMode.STRICT);
        }
        return (T)this.obtainDirect(field, fieldDef.getType(), GetMode.STRICT);
    }

    public final <T> void setValue(FieldDef<T> fieldDef, T value) {
        if (fieldDef == null) {
            return;
        }
        RecordDataSchema.Field field = fieldDef.getField();
        if (!this.fieldDefInRecord(fieldDef)) {
            throw new IllegalArgumentException("Field " + fieldDef.getName() + " is not a field belonging to the schema of this DynamicRecordTemplate.");
        }
        if (fieldDef.getType().isArray()) {
            this.putArray(field, fieldDef, value);
        } else if (DataTemplate.class.isAssignableFrom(fieldDef.getType())) {
            this.putWrapped(field, fieldDef.getType(), (DataTemplate)value);
        } else {
            this.putDirect(field, fieldDef.getType(), fieldDef.getDataClass(), value, fieldDef.getField().getOptional() ? SetMode.IGNORE_NULL : SetMode.DISALLOW_NULL);
        }
    }

    private boolean fieldDefInRecord(FieldDef<?> fieldDef) {
        return fieldDef.getField().getRecord() == this.schema();
    }

    private <T> T obtainArray(RecordDataSchema.Field field, FieldDef<T> fieldDef) {
        Class<?> itemType = fieldDef.getType().getComponentType();
        DataList itemsList = this.obtainDirect(field, DataList.class, GetMode.STRICT);
        Object convertedValue = Array.newInstance(itemType, itemsList.size());
        boolean isDataTemplate = DataTemplate.class.isAssignableFrom(itemType);
        int j = 0;
        for (Object item : itemsList) {
            DataTemplate itemsElem = null;
            itemsElem = isDataTemplate ? DataTemplateUtil.wrap(item, itemType.asSubclass(DataTemplate.class)) : (DataTemplate)DataTemplateUtil.coerceOutput(item, itemType);
            Array.set(convertedValue, j++, itemsElem);
        }
        return (T)convertedValue;
    }

    private <T> void putArray(RecordDataSchema.Field field, FieldDef<T> fieldDef, T value) {
        DataList data = new DataList();
        Class<?> itemType = null;
        ArrayDataSchema arrayDataSchema = null;
        if (fieldDef.getDataSchema() instanceof ArrayDataSchema) {
            arrayDataSchema = (ArrayDataSchema)fieldDef.getDataSchema();
            DataSchema itemSchema = arrayDataSchema.getItems();
            itemType = itemSchema instanceof TyperefDataSchema ? DataSchemaUtil.dataSchemaTypeToPrimitiveDataSchemaClass(itemSchema.getDereferencedType()) : fieldDef.getType().getComponentType();
        } else {
            throw new IllegalArgumentException("Field " + fieldDef.getName() + " does not have an array schema; although the data is an array.");
        }
        boolean isDataTemplate = DataTemplate.class.isAssignableFrom(itemType);
        List<Object> items = value instanceof DataList ? (List<Object>)value : Arrays.asList((Object[])value);
        for (Object item : items) {
            if (isDataTemplate) {
                Object itemData = item instanceof DataMap ? item : ((DataTemplate)item).data();
                data.add(itemData);
                continue;
            }
            data.add(DataTemplateUtil.coerceInput(item, item.getClass(), itemType.isEnum() ? String.class : itemType));
        }
        this.putDirect(field, DataList.class, data, SetMode.DISALLOW_NULL);
    }
}

