/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.store.hdfs;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.gobblin.config.store.hdfs.SimpleLocalHDFSConfigStoreFactory;
import org.apache.hadoop.fs.FileSystem;

public class DefaultCapableLocalConfigStoreFactory
extends SimpleLocalHDFSConfigStoreFactory {
    public static final String SCHEME_PREFIX = "default-";

    public DefaultCapableLocalConfigStoreFactory() {
    }

    public DefaultCapableLocalConfigStoreFactory(Config factoryConfig) {
        super(factoryConfig);
    }

    @Override
    protected URI getDefaultRootDir(Config factoryConfig, FileSystem defaultFileSystem, Optional<URI> configDefinedDefaultURI) {
        try {
            if (configDefinedDefaultURI.isPresent()) {
                return (URI)configDefinedDefaultURI.get();
            }
            return new URI(System.getProperty("user.dir"));
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
    }

    @Override
    protected String getSchemePrefix() {
        return SCHEME_PREFIX;
    }
}

