/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.store.hdfs;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.net.URI;
import org.apache.gobblin.config.store.hdfs.SimpleHadoopFilesystemConfigStoreFactory;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class SimpleHDFSConfigStoreFactory
extends SimpleHadoopFilesystemConfigStoreFactory {
    protected static final String HDFS_SCHEME_NAME = "hdfs";

    public SimpleHDFSConfigStoreFactory() {
        this(ConfigUtils.getConfigOrEmpty((Config)ConfigFactory.load(), (String)DEFAULT_CONFIG_NAMESPACE));
    }

    public SimpleHDFSConfigStoreFactory(Config factoryConfig) {
        super(factoryConfig);
    }

    @Override
    protected FileSystem getDefaultStoreFs(Config factoryConfig, Optional<URI> configDefinedDefaultURI) {
        try {
            if (configDefinedDefaultURI.isPresent() && ((URI)configDefinedDefaultURI.get()).getAuthority() != null) {
                return FileSystem.get((URI)((URI)configDefinedDefaultURI.get()), (Configuration)new Configuration());
            }
            FileSystem fs = FileSystem.get((Configuration)new Configuration());
            return HDFS_SCHEME_NAME.equals(fs.getScheme()) ? fs : null;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not create default store fs for scheme " + this.getScheme());
        }
    }

    @Override
    protected URI getDefaultRootDir(Config factoryConfig, FileSystem defaultFileSystem, Optional<URI> configDefinedDefaultURI) {
        return (URI)configDefinedDefaultURI.or((Object)defaultFileSystem.getHomeDirectory().toUri());
    }

    @Override
    protected String getPhysicalScheme() {
        return HDFS_SCHEME_NAME;
    }
}

