/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import java.time.Duration;
import java.time.Instant;

public class TimeoutTracker {
    private final Duration originalTimeout;
    private boolean isTimerStarted;
    private Instant startTime;

    public TimeoutTracker(Duration timeout, boolean startTrackingTimeout) {
        if (timeout.compareTo(Duration.ZERO) < 0) {
            throw new IllegalArgumentException("timeout should be non-negative");
        }
        this.originalTimeout = timeout;
        if (startTrackingTimeout) {
            this.startTime = Instant.now();
        }
        this.isTimerStarted = startTrackingTimeout;
    }

    public static TimeoutTracker create(Duration timeout) {
        return new TimeoutTracker(timeout, true);
    }

    public Duration remaining() {
        return this.originalTimeout.minus(this.elapsed());
    }

    public Duration elapsed() {
        if (!this.isTimerStarted) {
            this.startTime = Instant.now();
            this.isTimerStarted = true;
        }
        return Duration.between(this.startTime, Instant.now());
    }
}

