/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform.filter;

import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.transform.DataComplexProcessor;
import com.linkedin.data.transform.DataProcessingException;
import com.linkedin.data.transform.Escaper;
import com.linkedin.data.transform.filter.DefaultNodeModeCalculator;
import com.linkedin.data.transform.filter.FilterConstants;
import com.linkedin.data.transform.filter.FilterUtil;
import com.linkedin.data.transform.filter.MaskComposition;
import com.linkedin.data.transform.filter.NodeMode;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractFilter {
    private final DefaultNodeModeCalculator _dafaultNodeModeCalculator = new DefaultNodeModeCalculator();

    public Object filter(Object data, DataMap opNode) {
        if (data != null && opNode != null) {
            NodeMode defaultMode = this._dafaultNodeModeCalculator.getDefaultNodeMode(opNode);
            DataMap complexWildCard = AbstractFilter.getComplexWildCard(opNode);
            if (data.getClass() == DataList.class) {
                return this.filterDataList(opNode, (DataList)data);
            }
            if (data.getClass() == DataMap.class) {
                return this.filterDataMap(opNode, (DataMap)data, defaultMode, complexWildCard);
            }
            return this.onError(null, "Data type in instruction must be DataMap or DataList, but is: %1$s", data.getClass().getName());
        }
        return this.onError(null, "Either data or operation is null", new Object[0]);
    }

    protected abstract Object onFilterDataList(DataList var1, int var2, int var3, Object var4);

    protected abstract Object onFilterDataMap(DataMap var1, Map<String, Object> var2);

    protected abstract Object onError(Object var1, String var2, Object ... var3);

    protected abstract boolean isValidDataMapFieldOperation(Map<String, Object> var1, String var2, Object var3);

    private static DataMap getComplexWildCard(DataMap opNode) {
        assert (opNode != null);
        Object o = opNode.get((Object)"$*");
        if (o != null && o.getClass() == DataMap.class) {
            return (DataMap)o;
        }
        return null;
    }

    private static boolean areFieldsExplicitlyRemoved(NodeMode defaultMode) {
        return defaultMode.equals((Object)NodeMode.HIDE_HIGH);
    }

    private static boolean isValidMaskType(Object mask) {
        return mask == null || mask.getClass() == Integer.class || mask.getClass() == DataMap.class;
    }

    private static DataMap wildcard(Integer v) {
        DataMap wildcardMap = new DataMap();
        wildcardMap.put((Object)"$*", (Object)v);
        return wildcardMap;
    }

    private static NodeMode getExplicitNodeMode(DataMap opNode, String name) {
        assert (opNode != null);
        Object childModeObj = opNode.get((Object)Escaper.replaceAll(name, "$", "$$"));
        if (childModeObj != null && childModeObj.getClass() != DataMap.class && childModeObj instanceof Integer) {
            return NodeMode.fromRepresentation((Integer)childModeObj);
        }
        return null;
    }

    private Object filterDataList(DataMap opNode, DataList valueDataList) {
        Integer count;
        assert (opNode != null);
        Integer start = FilterUtil.getIntegerWithDefaultValue(opNode, "$start", 0);
        if (start == null || start < 0) {
            this.onError(null, "value of %1$s must be positive integer but is equal to %2$d", "$start", start);
        }
        if ((count = FilterUtil.getIntegerWithDefaultValue(opNode, "$count", Integer.MAX_VALUE)) == null || count < 0) {
            this.onError(null, "value of %1$s must be positive integer but is equal to %2$d", "$count", count);
        }
        if (start != null && start >= 0 && count != null && count >= 0) {
            Object operation = this.filterByWildcard(opNode, valueDataList);
            return this.onFilterDataList(valueDataList, start, count, operation);
        }
        return null;
    }

    private Object filterByWildcard(DataMap opNode, DataList valueDataList) {
        Object wildcard = opNode.get((Object)"$*");
        if (wildcard != null) {
            if (wildcard.equals(FilterConstants.NEGATIVE)) {
                return FilterConstants.NEGATIVE;
            }
            if (wildcard.getClass() == DataMap.class) {
                for (int i = 0; i < valueDataList.size(); ++i) {
                    Object elem = valueDataList.get(i);
                    if (elem instanceof DataComplex) continue;
                    this.onError(i, "complex filter defined for array element, which is not an object nor an array, but it is of type: %1$s, with value: %2$s", elem.getClass().getName(), elem);
                }
                return wildcard;
            }
            if (!wildcard.equals(FilterConstants.POSITIVE)) {
                this.onError(null, "wildcard can be either 0, 1 or DataMap instance, but it is of type: %1$s, equal to: %2$s", wildcard.getClass().getName(), wildcard);
            }
        }
        return FilterConstants.POSITIVE;
    }

    private Object filterDataMap(DataMap opNode, DataMap valueDataMap, NodeMode defaultMode, DataMap complexWildCard) {
        assert (opNode != null);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : valueDataMap.entrySet()) {
            String name = (String)entry.getKey();
            Object childValue = entry.getValue();
            if (!AbstractFilter.isValidMaskType(opNode.get((Object)Escaper.replaceAll(name, "$", "$$")))) {
                this.onError(name, "mask value for field %2$s should be of type Integer or DataMap, instead it is of type: %1$s, ", opNode.get((Object)Escaper.replaceAll(name, "$", "$$")), name);
                continue;
            }
            Integer operation = FilterConstants.POSITIVE;
            NodeMode explicitFieldMode = AbstractFilter.getExplicitNodeMode(opNode, name);
            if (explicitFieldMode != null) {
                DataMap composed;
                if (AbstractFilter.areFieldsExplicitlyRemoved(explicitFieldMode)) {
                    operation = FilterConstants.NEGATIVE;
                } else if (complexWildCard != null && childValue instanceof DataComplex && (composed = this.compose(name, complexWildCard, AbstractFilter.wildcard(1))) != null) {
                    operation = composed;
                }
            } else {
                Object opChild = opNode.get((Object)Escaper.replaceAll(name, "$", "$$"));
                if (opChild == null) {
                    if (AbstractFilter.areFieldsExplicitlyRemoved(defaultMode) || this.areFieldsImplicitlyRemoved(defaultMode, complexWildCard)) {
                        operation = FilterConstants.NEGATIVE;
                    } else if (complexWildCard != null) {
                        if (childValue instanceof DataComplex) {
                            operation = complexWildCard;
                        } else if (this.needsRemoving(defaultMode, complexWildCard)) {
                            operation = FilterConstants.NEGATIVE;
                        }
                    }
                } else {
                    DataMap effectiveMask;
                    assert (opChild.getClass() == DataMap.class) : opChild;
                    Object rawWildcard = opNode.get((Object)"$*");
                    DataMap effectiveComplexWildcard = rawWildcard != null && rawWildcard.equals(FilterConstants.POSITIVE) ? AbstractFilter.wildcard(FilterConstants.POSITIVE) : (DataMap)rawWildcard;
                    DataMap dataMap = effectiveMask = effectiveComplexWildcard == null ? (DataMap)opChild : this.compose(name, (DataMap)opChild, effectiveComplexWildcard);
                    if (this.needsRemoving(defaultMode, effectiveMask)) {
                        operation = FilterConstants.NEGATIVE;
                    } else if (childValue instanceof DataComplex) {
                        operation = effectiveMask;
                    } else {
                        this.onError(name, "data is of primitive value: %1$s, but filter: %2$s is complex", childValue, opChild);
                    }
                }
            }
            if (!this.isValidDataMapFieldOperation(result, name, operation)) continue;
            result.put(name, operation);
        }
        return this.onFilterDataMap(valueDataMap, result);
    }

    private boolean needsRemoving(NodeMode defaultMode, DataMap effectiveMask) {
        return AbstractFilter.areFieldsExplicitlyRemoved(defaultMode) || defaultMode.equals((Object)NodeMode.HIDE_LOW) && (this._dafaultNodeModeCalculator.getDefaultNodeMode(effectiveMask).equals((Object)NodeMode.SHOW_LOW) || this._dafaultNodeModeCalculator.getDefaultNodeMode(effectiveMask).equals((Object)NodeMode.HIDE_HIGH));
    }

    private boolean areFieldsImplicitlyRemoved(NodeMode defaultMode, DataMap complexWildCard) {
        return defaultMode.equals((Object)NodeMode.HIDE_LOW) && (complexWildCard == null || !this._dafaultNodeModeCalculator.getDefaultNodeMode(complexWildCard).equals((Object)NodeMode.HIDE_LOW));
    }

    private DataMap compose(String fieldName, DataMap mask1, DataMap mask2) {
        assert (mask2 != null);
        assert (mask1 != null);
        try {
            DataMap clone = mask1.copy();
            new DataComplexProcessor(new MaskComposition(), mask2, (DataComplex)clone).run(true);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            this.onError(fieldName, "could not clone mask: %1$s, exception: %2$s", mask1, e);
        }
        catch (DataProcessingException e) {
            this.onError(fieldName, "error composing mask %1$s with %2$s, exception: %3$s", mask1, mask2, e);
        }
        return null;
    }
}

