/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform.filter;

import com.linkedin.data.DataComplex;
import com.linkedin.data.DataMap;
import com.linkedin.data.transform.Instruction;
import com.linkedin.data.transform.Interpreter;
import com.linkedin.data.transform.InterpreterContext;
import com.linkedin.data.transform.filter.FilterConstants;
import com.linkedin.data.transform.filter.FilterUtil;
import java.util.ArrayList;
import java.util.Map;

public class MaskComposition
implements Interpreter {
    @Override
    public void interpret(InterpreterContext instrCtx) {
        Instruction instruction = instrCtx.getCurrentInstruction();
        if (instruction.getData().getClass() != DataMap.class || instruction.getOperation().getClass() != DataMap.class) {
            instrCtx.addErrorMessage("data and operation in composition instruction have to be of type DataMap, instruction: %1$s", instruction);
        } else {
            DataMap data = (DataMap)instruction.getData();
            DataMap op = (DataMap)instruction.getOperation();
            Object opWildcard = op.get((Object)"$*");
            Object dataWildcard = data.get((Object)"$*");
            if (opWildcard != null && opWildcard.equals(FilterConstants.NEGATIVE) || dataWildcard != null && dataWildcard.equals(FilterConstants.NEGATIVE)) {
                this.handleNegativeWildcard(data);
            } else {
                this.composeArrayRange(data, op, instrCtx);
                for (Map.Entry entry : op.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    Object opMask = entry.getValue();
                    Object dataMask = data.get((Object)fieldName);
                    if (fieldName.equals("$start") || fieldName.equals("$count")) continue;
                    this.composeField(fieldName, opMask, dataMask, data, dataWildcard, instrCtx);
                }
            }
        }
    }

    protected void composeArrayRange(DataMap data, DataMap op, InterpreterContext instrCtx) {
        Integer countOp;
        Integer countData;
        Integer startOp;
        Integer startData = FilterUtil.getIntegerWithDefaultValue(data, "$start", 0);
        if (startData == null) {
            this.addValueTypeNotIntegerError(data, "$start", instrCtx);
        }
        if ((startOp = FilterUtil.getIntegerWithDefaultValue(op, "$start", 0)) == null) {
            this.addValueTypeNotIntegerError(op, "$start", instrCtx);
        }
        if ((countData = FilterUtil.getIntegerWithDefaultValue(data, "$count", Integer.MAX_VALUE)) == null) {
            this.addValueTypeNotIntegerError(data, "$count", instrCtx);
        }
        if ((countOp = FilterUtil.getIntegerWithDefaultValue(op, "$count", Integer.MAX_VALUE)) == null) {
            this.addValueTypeNotIntegerError(op, "$count", instrCtx);
        }
        if (startData < 0) {
            this.addNegativeIntegerError(data, "$start", startData, instrCtx);
        }
        if (startOp < 0) {
            this.addNegativeIntegerError(op, "$start", startOp, instrCtx);
        }
        if (countData < 0) {
            this.addNegativeIntegerError(data, "$count", countData, instrCtx);
        }
        if (countOp < 0) {
            this.addNegativeIntegerError(op, "$count", countOp, instrCtx);
        }
        if (startData != null && startOp != null && countData != null && countOp != null && startData >= 0 && startOp >= 0 && countData >= 0 && countOp >= 0) {
            Integer start = Math.min(startData, startOp);
            Integer count = Math.max(startData + countData, startOp + countOp) - start;
            this.storeNonDefaultValue(data, "$start", 0, start);
            this.storeNonDefaultValue(data, "$count", Integer.MAX_VALUE, count);
        }
    }

    private void addNegativeIntegerError(DataMap data, String fieldName, Integer value, InterpreterContext instrCtx) {
        instrCtx.addErrorMessage("value %1$s must be positive but is equal to %2$d", fieldName, value);
    }

    private void addValueTypeNotIntegerError(DataMap data, String fieldName, InterpreterContext instrCtx) {
        instrCtx.addErrorMessage("value should be of type Integer, but is of type: %1$s", data.get((Object)fieldName).getClass().getName());
    }

    protected void storeNonDefaultValue(DataMap data, String tag, Integer defaultValue, Integer value) {
        if (value.equals(defaultValue)) {
            data.remove((Object)tag);
        } else {
            data.put((Object)tag, (Object)value);
        }
    }

    private DataMap cloneDataMap(DataMap data, InterpreterContext instrCtx) {
        try {
            return data.copy();
        }
        catch (CloneNotSupportedException e) {
            instrCtx.addErrorMessage("could not clone mask: %1$s, exception: %2$s", data, e);
            return null;
        }
    }

    private void handleNegativeWildcard(DataMap data) {
        data.clear();
        data.put((Object)"$*", (Object)FilterConstants.NEGATIVE);
    }

    boolean mergeWith1(DataMap mask, DataMap parent, String key) {
        assert (mask != null);
        this.prunePositiveMask(mask);
        Object wildcard = mask.get((Object)"$*");
        if (wildcard == null) {
            mask.put((Object)"$*", (Object)FilterConstants.POSITIVE);
            wildcard = FilterConstants.POSITIVE;
        } else if (!wildcard.equals(FilterConstants.POSITIVE)) {
            this.mergeWith1((DataMap)wildcard, mask, "$*");
        }
        if (mask.size() == 1 && wildcard != null && wildcard.equals(FilterConstants.POSITIVE)) {
            parent.put((Object)key, (Object)FilterConstants.POSITIVE);
            return true;
        }
        return false;
    }

    private void removeArrayRenges(DataMap data) {
        data.remove((Object)"$start");
        data.remove((Object)"$count");
    }

    private boolean composeField(String fieldName, Object opMask, Object dataMask, DataMap data, Object dataWildcard, InterpreterContext instrCtx) {
        instrCtx.setCurrentField(fieldName);
        boolean failed = false;
        if (dataMask == null) {
            if (!opMask.equals(FilterConstants.POSITIVE) || !FilterUtil.isMarkedAsMergedWith1(data)) {
                data.put((Object)fieldName, opMask);
            }
        } else if (dataMask instanceof Integer) {
            if (((Integer)dataMask).equals(FilterConstants.POSITIVE)) {
                if (opMask instanceof Integer) {
                    Integer merged = this.merge((Integer)dataMask, (Integer)opMask, instrCtx);
                    if (merged != null) {
                        data.put((Object)fieldName, (Object)merged);
                    } else {
                        failed = true;
                    }
                } else if (opMask.getClass() == DataMap.class) {
                    if ((opMask = this.cloneDataMap((DataMap)opMask, instrCtx)) != null) {
                        if (!this.mergeWith1((DataMap)opMask, data, fieldName)) {
                            data.put((Object)fieldName, opMask);
                        }
                    } else {
                        failed = true;
                    }
                } else {
                    instrCtx.addErrorMessage("field mask value of unsupported type: %1$s", opMask.getClass().getName());
                    failed = true;
                }
            }
        } else if (dataMask.getClass() == DataMap.class) {
            if (opMask instanceof Integer) {
                if (((Integer)opMask).equals(FilterConstants.NEGATIVE)) {
                    data.put((Object)fieldName, (Object)FilterConstants.NEGATIVE);
                } else {
                    this.mergeWith1((DataMap)dataMask, data, fieldName);
                }
            } else if (opMask.getClass() == DataMap.class) {
                instrCtx.scheduleInstruction(new Instruction((DataMap)opMask, (DataComplex)((DataMap)dataMask), instrCtx.getPath()));
            } else {
                instrCtx.addErrorMessage("field mask value of unsupported type: %1$s", opMask.getClass().getName());
                failed = true;
            }
        } else {
            instrCtx.addErrorMessage("field mask value of unsupported type: %1$s", dataMask.getClass().getName());
            failed = true;
        }
        return !failed;
    }

    private boolean isValidMaskValue(Integer v, InterpreterContext ic) {
        if (v < 0 || v > 1) {
            ic.addErrorMessage("mask value have to be 0 or 1, but is: %1$s", v);
            return false;
        }
        return true;
    }

    private Integer merge(Integer m1, Integer m2, InterpreterContext instrCtx) {
        if (this.isValidMaskValue(m1, instrCtx) && this.isValidMaskValue(m2, instrCtx)) {
            return m1 < m2 ? m1 : m2;
        }
        return null;
    }

    private void prunePositiveMask(DataMap complex) {
        this.removeArrayRenges(complex);
        ArrayList toBeRemoved = new ArrayList();
        for (Map.Entry entry : complex.entrySet()) {
            Object v = entry.getValue();
            if (v.equals(FilterConstants.POSITIVE)) {
                toBeRemoved.add(entry.getKey());
            }
            if (v.getClass() != DataMap.class) continue;
            this.prunePositiveMask((DataMap)v);
            if (((DataMap)v).size() != 0) continue;
            toBeRemoved.add(entry.getKey());
        }
        for (String name : toBeRemoved) {
            complex.remove((Object)name);
        }
    }
}

