/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazybinary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazybinary.objectinspector.LazyBinaryObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.WritableUtils;

public final class LazyBinaryUtils {
    private static Log LOG = LogFactory.getLog((String)LazyBinaryUtils.class.getName());
    public static final ThreadLocal<VInt> threadLocalVInt = new ThreadLocal<VInt>(){

        @Override
        protected VInt initialValue() {
            return new VInt();
        }
    };
    private static ThreadLocal<byte[]> vLongBytesThreadLocal = new ThreadLocal<byte[]>(){

        @Override
        public byte[] initialValue() {
            return new byte[9];
        }
    };
    static HashMap<TypeInfo, ObjectInspector> cachedLazyBinaryObjectInspector = new HashMap();

    public static int byteArrayToInt(byte[] b, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
        }
        return value;
    }

    public static long byteArrayToLong(byte[] b, int offset) {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            int shift = (7 - i) * 8;
            value += (long)(b[i + offset] & 0xFF) << shift;
        }
        return value;
    }

    public static short byteArrayToShort(byte[] b, int offset) {
        short value = 0;
        value = (short)(value + ((b[offset] & 0xFF) << 8));
        value = (short)(value + (b[offset + 1] & 0xFF));
        return value;
    }

    public static void checkObjectByteInfo(ObjectInspector objectInspector, byte[] bytes, int offset, RecordInfo recordInfo, VInt vInt) {
        ObjectInspector.Category category = objectInspector.getCategory();
        block0 : switch (category) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveObjectInspector)objectInspector).getPrimitiveCategory();
                switch (primitiveCategory) {
                    case VOID: {
                        recordInfo.elementOffset = 0;
                        recordInfo.elementSize = 0;
                        break block0;
                    }
                    case BOOLEAN: 
                    case BYTE: {
                        recordInfo.elementOffset = 0;
                        recordInfo.elementSize = 1;
                        break block0;
                    }
                    case SHORT: {
                        recordInfo.elementOffset = 0;
                        recordInfo.elementSize = 2;
                        break block0;
                    }
                    case FLOAT: {
                        recordInfo.elementOffset = 0;
                        recordInfo.elementSize = 4;
                        break block0;
                    }
                    case DOUBLE: {
                        recordInfo.elementOffset = 0;
                        recordInfo.elementSize = 8;
                        break block0;
                    }
                    case INT: {
                        recordInfo.elementOffset = 0;
                        recordInfo.elementSize = WritableUtils.decodeVIntSize((byte)bytes[offset]);
                        break block0;
                    }
                    case LONG: {
                        recordInfo.elementOffset = 0;
                        recordInfo.elementSize = WritableUtils.decodeVIntSize((byte)bytes[offset]);
                        break block0;
                    }
                    case STRING: {
                        LazyBinaryUtils.readVInt(bytes, offset, vInt);
                        recordInfo.elementOffset = vInt.length;
                        recordInfo.elementSize = vInt.value;
                        break block0;
                    }
                    case CHAR: 
                    case VARCHAR: {
                        LazyBinaryUtils.readVInt(bytes, offset, vInt);
                        recordInfo.elementOffset = vInt.length;
                        recordInfo.elementSize = vInt.value;
                        break block0;
                    }
                    case BINARY: {
                        LazyBinaryUtils.readVInt(bytes, offset, vInt);
                        recordInfo.elementOffset = vInt.length;
                        recordInfo.elementSize = vInt.value;
                        break block0;
                    }
                    case DATE: {
                        recordInfo.elementOffset = 0;
                        recordInfo.elementSize = WritableUtils.decodeVIntSize((byte)bytes[offset]);
                        break block0;
                    }
                    case TIMESTAMP: {
                        recordInfo.elementOffset = 0;
                        recordInfo.elementSize = TimestampWritable.getTotalLength(bytes, offset);
                        break block0;
                    }
                    case DECIMAL: {
                        LazyBinaryUtils.readVInt(bytes, offset, vInt);
                        recordInfo.elementOffset = 0;
                        recordInfo.elementSize = vInt.length;
                        LazyBinaryUtils.readVInt(bytes, offset + vInt.length, vInt);
                        recordInfo.elementSize += vInt.length + vInt.value;
                        break block0;
                    }
                }
                throw new RuntimeException("Unrecognized primitive type: " + (Object)((Object)primitiveCategory));
            }
            case LIST: 
            case MAP: 
            case STRUCT: 
            case UNION: {
                recordInfo.elementOffset = (byte)4;
                recordInfo.elementSize = LazyBinaryUtils.byteArrayToInt(bytes, offset);
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized non-primitive type: " + (Object)((Object)category));
            }
        }
    }

    public static void readVLong(byte[] bytes, int offset, VLong vlong) {
        byte firstByte = bytes[offset];
        vlong.length = (byte)WritableUtils.decodeVIntSize((byte)firstByte);
        if (vlong.length == 1) {
            vlong.value = firstByte;
            return;
        }
        long i = 0L;
        for (int idx = 0; idx < vlong.length - 1; ++idx) {
            byte b = bytes[offset + 1 + idx];
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        vlong.value = WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static void readVInt(byte[] bytes, int offset, VInt vInt) {
        byte firstByte = bytes[offset];
        vInt.length = (byte)WritableUtils.decodeVIntSize((byte)firstByte);
        if (vInt.length == 1) {
            vInt.value = firstByte;
            return;
        }
        int i = 0;
        for (int idx = 0; idx < vInt.length - 1; ++idx) {
            byte b = bytes[offset + 1 + idx];
            i <<= 8;
            i |= b & 0xFF;
        }
        vInt.value = WritableUtils.isNegativeVInt((byte)firstByte) ? ~i : i;
    }

    public static void writeVInt(ByteStream.RandomAccessOutput byteStream, int i) {
        LazyBinaryUtils.writeVLong(byteStream, i);
    }

    public static long readVLongFromByteArray(byte[] bytes, int offset) {
        byte firstByte;
        int len;
        if ((len = WritableUtils.decodeVIntSize((byte)(firstByte = bytes[offset++]))) == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = bytes[offset++];
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int writeVLongToByteArray(byte[] bytes, long l) {
        return LazyBinaryUtils.writeVLongToByteArray(bytes, 0, l);
    }

    public static int writeVLongToByteArray(byte[] bytes, int offset, long l) {
        if (l >= -112L && l <= 127L) {
            bytes[offset] = (byte)l;
            return 1;
        }
        int len = -112;
        if (l < 0L) {
            l ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = l;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        bytes[offset] = (byte)len;
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            bytes[offset + 1 - (idx - len)] = (byte)((l & mask) >> shiftbits);
        }
        return 1 + len;
    }

    public static void writeVLong(ByteStream.RandomAccessOutput byteStream, long l) {
        byte[] vLongBytes = vLongBytesThreadLocal.get();
        int len = LazyBinaryUtils.writeVLongToByteArray(vLongBytes, l);
        byteStream.write(vLongBytes, 0, len);
    }

    public static void writeDouble(ByteStream.RandomAccessOutput byteStream, double d) {
        long v = Double.doubleToLongBits(d);
        byteStream.write((byte)(v >> 56));
        byteStream.write((byte)(v >> 48));
        byteStream.write((byte)(v >> 40));
        byteStream.write((byte)(v >> 32));
        byteStream.write((byte)(v >> 24));
        byteStream.write((byte)(v >> 16));
        byteStream.write((byte)(v >> 8));
        byteStream.write((byte)v);
    }

    public static ObjectInspector getLazyBinaryObjectInspectorFromTypeInfo(TypeInfo typeInfo) {
        ObjectInspector result = cachedLazyBinaryObjectInspector.get(typeInfo);
        if (result == null) {
            switch (typeInfo.getCategory()) {
                case PRIMITIVE: {
                    result = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)typeInfo);
                    break;
                }
                case LIST: {
                    ObjectInspector elementObjectInspector = LazyBinaryUtils.getLazyBinaryObjectInspectorFromTypeInfo(((ListTypeInfo)typeInfo).getListElementTypeInfo());
                    result = LazyBinaryObjectInspectorFactory.getLazyBinaryListObjectInspector(elementObjectInspector);
                    break;
                }
                case MAP: {
                    MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                    ObjectInspector keyObjectInspector = LazyBinaryUtils.getLazyBinaryObjectInspectorFromTypeInfo(mapTypeInfo.getMapKeyTypeInfo());
                    ObjectInspector valueObjectInspector = LazyBinaryUtils.getLazyBinaryObjectInspectorFromTypeInfo(mapTypeInfo.getMapValueTypeInfo());
                    result = LazyBinaryObjectInspectorFactory.getLazyBinaryMapObjectInspector(keyObjectInspector, valueObjectInspector);
                    break;
                }
                case STRUCT: {
                    StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                    ArrayList<String> fieldNames = structTypeInfo.getAllStructFieldNames();
                    ArrayList<TypeInfo> fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                    ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(fieldTypeInfos.size());
                    for (int i = 0; i < fieldTypeInfos.size(); ++i) {
                        fieldObjectInspectors.add(LazyBinaryUtils.getLazyBinaryObjectInspectorFromTypeInfo((TypeInfo)fieldTypeInfos.get(i)));
                    }
                    result = LazyBinaryObjectInspectorFactory.getLazyBinaryStructObjectInspector(fieldNames, fieldObjectInspectors);
                    break;
                }
                case UNION: {
                    UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                    List<TypeInfo> fieldTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
                    ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(fieldTypeInfos.size());
                    for (int i = 0; i < fieldTypeInfos.size(); ++i) {
                        fieldObjectInspectors.add(LazyBinaryUtils.getLazyBinaryObjectInspectorFromTypeInfo(fieldTypeInfos.get(i)));
                    }
                    result = LazyBinaryObjectInspectorFactory.getLazyBinaryUnionObjectInspector(fieldObjectInspectors);
                    break;
                }
                default: {
                    result = null;
                }
            }
            cachedLazyBinaryObjectInspector.put(typeInfo, result);
        }
        return result;
    }

    private LazyBinaryUtils() {
    }

    public static class VInt {
        public int value = 0;
        public byte length = 0;
    }

    public static class VLong {
        public long value = 0L;
        public byte length = 0;
    }

    public static class RecordInfo {
        public byte elementOffset = 0;
        public int elementSize = 0;

        public String toString() {
            return "(" + this.elementOffset + ", " + this.elementSize + ")";
        }
    }
}

