/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.admin;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminWebServer
extends AbstractIdleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdminWebServer.class);
    private final URI restServerUri;
    private final URI serverUri;
    private final String hideJobsWithoutTasksByDefault;
    private final long refreshInterval;
    protected Server server;

    public AdminWebServer(Properties properties, URI restServerUri) {
        Preconditions.checkNotNull((Object)properties);
        Preconditions.checkNotNull((Object)restServerUri);
        this.restServerUri = restServerUri;
        int port = AdminWebServer.getPort(properties);
        this.serverUri = URI.create(String.format("http://%s:%d", AdminWebServer.getHost(properties), port));
        this.hideJobsWithoutTasksByDefault = properties.getProperty("admin.server.hide_jobs_without_tasks_by_default.enabled", "false");
        this.refreshInterval = AdminWebServer.getRefreshInterval(properties);
    }

    protected void startUp() throws Exception {
        LOGGER.info("Starting the admin web server");
        this.server = new Server(new InetSocketAddress(this.serverUri.getHost(), this.serverUri.getPort()));
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.addHandler(this.buildSettingsHandler());
        handlerCollection.addHandler((Handler)this.buildStaticResourceHandler());
        this.server.setHandler((Handler)handlerCollection);
        this.server.start();
    }

    private Handler buildSettingsHandler() {
        String responseTemplate = "var Gobblin = window.Gobblin || {};Gobblin.settings = {restServerUrl:\"%s\", hideJobsWithoutTasksByDefault:%s, refreshInterval:%s}";
        return new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (request.getRequestURI().equals("/js/settings.js")) {
                    response.setContentType("application/javascript");
                    response.setStatus(200);
                    response.getWriter().println(String.format("var Gobblin = window.Gobblin || {};Gobblin.settings = {restServerUrl:\"%s\", hideJobsWithoutTasksByDefault:%s, refreshInterval:%s}", AdminWebServer.this.restServerUri.toString(), AdminWebServer.this.hideJobsWithoutTasksByDefault, AdminWebServer.this.refreshInterval));
                    baseRequest.setHandled(true);
                }
            }
        };
    }

    private ResourceHandler buildStaticResourceHandler() {
        ResourceHandler staticResourceHandler = new ResourceHandler();
        staticResourceHandler.setDirectoriesListed(true);
        staticResourceHandler.setWelcomeFiles(new String[]{"index.html"});
        String staticDir = ((Object)((Object)this)).getClass().getClassLoader().getResource("static").toExternalForm();
        staticResourceHandler.setResourceBase(staticDir);
        return staticResourceHandler;
    }

    protected void shutDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private static int getPort(Properties properties) {
        return Integer.parseInt(properties.getProperty("admin.server.port", "8000"));
    }

    private static String getHost(Properties properties) {
        return properties.getProperty("admin.server.host", "localhost");
    }

    private static long getRefreshInterval(Properties properties) {
        return Long.parseLong(properties.getProperty("admin.server.refresh_interval", "30000"));
    }
}

