/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.cli;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.runtime.cli.CliApplication;
import org.apache.gobblin.runtime.cli.EmbeddedGobblinCliFactory;
import org.apache.gobblin.runtime.embedded.EmbeddedGobblin;
import org.apache.gobblin.util.ClassAliasResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="run", description="Run a Gobblin application.")
public class CliEmbeddedGobblin
implements CliApplication {
    private static final Logger log = LoggerFactory.getLogger(CliEmbeddedGobblin.class);
    public static final String LIST_QUICK_APPS = "listQuickApps";

    public void run(String[] args) throws IOException {
        EmbeddedGobblinCliFactory factory;
        int startOptions = 1;
        String alias = "";
        if (args.length >= 2 && !args[1].startsWith("-")) {
            alias = args[1];
            startOptions = 2;
        }
        if (alias.equals(LIST_QUICK_APPS)) {
            this.listQuickApps();
            return;
        }
        if (!Strings.isNullOrEmpty((String)alias)) {
            try {
                ClassAliasResolver resolver = new ClassAliasResolver(EmbeddedGobblinCliFactory.class);
                Class factoryClass = resolver.resolveClass(alias);
                factory = (EmbeddedGobblinCliFactory)factoryClass.newInstance();
            }
            catch (ReflectiveOperationException roe) {
                System.out.println("Error: Could not find job with alias " + alias);
                System.out.println("For a list of jobs available: \"gobblin run listQuickApps\"");
                return;
            }
        } else {
            factory = new EmbeddedGobblin.CliFactory();
        }
        String usage = Strings.isNullOrEmpty((String)alias) ? "gobblin run [listQuickApps] [<quick-app>] " + factory.getUsageString() : "gobblin run " + alias + " " + factory.getUsageString();
        EmbeddedGobblin embeddedGobblin = (EmbeddedGobblin)factory.buildObject(args, startOptions, true, usage);
        try {
            embeddedGobblin.run();
        }
        catch (InterruptedException | ExecutionException | TimeoutException exc) {
            throw new RuntimeException("Failed to run Gobblin job.", exc);
        }
    }

    private List<Alias> getAllAliases() {
        ClassAliasResolver resolver = new ClassAliasResolver(EmbeddedGobblinCliFactory.class);
        return resolver.getAliasObjects();
    }

    private void listQuickApps() {
        List<Alias> aliases = this.getAllAliases();
        System.out.println("Usage: gobblin run <quick-app-name> [OPTIONS]");
        System.out.println("Available quick apps:");
        for (Alias thisAlias : aliases) {
            System.out.println(String.format("\t%s\t-\t%s", thisAlias.value(), thisAlias.description()));
        }
    }
}

