/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.listeners;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.gobblin.runtime.JobContext;
import org.apache.gobblin.runtime.listeners.CloseableJobListener;
import org.apache.gobblin.runtime.listeners.JobListener;
import org.apache.gobblin.util.ExecutorsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobListeners {
    public static CloseableJobListener parallelJobListener(List<JobListener> jobListeners) {
        Iterables.removeIf(jobListeners, (Predicate)Predicates.isNull());
        return new ParallelJobListener(jobListeners);
    }

    private static final class ParallelJobListener
    implements CloseableJobListener {
        private static final Logger LOGGER = LoggerFactory.getLogger(ParallelJobListener.class);
        private final List<JobListener> jobListeners;
        private final ExecutorService executor;
        private final CompletionService<Void> completionService;

        public ParallelJobListener(List<JobListener> jobListeners) {
            this.jobListeners = jobListeners;
            this.executor = Executors.newCachedThreadPool(ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)LOGGER), (Optional)Optional.of((Object)"ParallelJobListener")));
            this.completionService = new ExecutorCompletionService<Void>(this.executor);
        }

        @Override
        public void onJobPrepare(final JobContext jobContext) {
            for (final JobListener jobListener : this.jobListeners) {
                this.completionService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        jobListener.onJobPrepare(jobContext);
                        return null;
                    }
                });
            }
        }

        @Override
        public void onJobStart(final JobContext jobContext) {
            for (final JobListener jobListener : this.jobListeners) {
                this.completionService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        jobListener.onJobStart(jobContext);
                        return null;
                    }
                });
            }
        }

        @Override
        public void onJobCompletion(final JobContext jobContext) {
            for (final JobListener jobListener : this.jobListeners) {
                this.completionService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        jobListener.onJobCompletion(jobContext);
                        return null;
                    }
                });
            }
        }

        @Override
        public void onJobCancellation(final JobContext jobContext) {
            for (final JobListener jobListener : this.jobListeners) {
                this.completionService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        jobListener.onJobCancellation(jobContext);
                        return null;
                    }
                });
            }
        }

        @Override
        public void onJobFailure(final JobContext jobContext) {
            for (final JobListener jobListener : this.jobListeners) {
                this.completionService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        jobListener.onJobFailure(jobContext);
                        return null;
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                boolean wasInterrupted = false;
                IOException exception = null;
                for (int i = 0; i < this.jobListeners.size(); ++i) {
                    try {
                        if (wasInterrupted) {
                            this.completionService.take().cancel(true);
                            continue;
                        }
                        this.completionService.take().get();
                        continue;
                    }
                    catch (InterruptedException ie) {
                        wasInterrupted = true;
                        if (exception != null) continue;
                        exception = new IOException(ie);
                        continue;
                    }
                    catch (ExecutionException ee) {
                        if (exception != null) continue;
                        exception = new IOException(ee.getCause());
                    }
                }
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                if (exception != null) {
                    throw exception;
                }
            }
            finally {
                ExecutorsUtils.shutdownExecutorService((ExecutorService)this.executor, (Optional)Optional.of((Object)LOGGER));
                this.closeJobListeners();
            }
        }

        private void closeJobListeners() throws IOException {
            IOException exception = null;
            for (JobListener jobListener : this.jobListeners) {
                if (!(jobListener instanceof Closeable)) continue;
                try {
                    ((Closeable)((Object)jobListener)).close();
                }
                catch (IOException e) {
                    if (exception == null) {
                        exception = e;
                        continue;
                    }
                    LOGGER.warn("JobListener failed while calling close.  Suppressed exception beyond first.", (Throwable)e);
                    exception.addSuppressed(e);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }
}

