/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.util;

import com.google.common.io.Closer;
import com.google.gson.stream.JsonWriter;
import com.typesafe.config.Config;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.metastore.DatasetStateStore;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.JobConfigurationUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobStateToJsonConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobStateToJsonConverter.class);
    private static final String JOB_STATE_STORE_TABLE_SUFFIX = ".jst";
    private final StateStore<? extends JobState> jobStateStore;
    private final boolean keepConfig;

    public JobStateToJsonConverter(Properties props, String storeUrl, boolean keepConfig) throws IOException {
        Configuration conf = new Configuration();
        JobConfigurationUtils.putPropertiesIntoConfiguration((Properties)props, (Configuration)conf);
        if (StringUtils.isNotBlank((String)storeUrl)) {
            props.setProperty("state.store.dir", storeUrl);
        }
        this.keepConfig = keepConfig;
        this.jobStateStore = DatasetStateStore.buildDatasetStateStore((Config)ConfigUtils.propertiesToConfig((Properties)props));
    }

    public void convert(String jobName, String jobId, Writer writer) throws IOException {
        List jobStates = this.jobStateStore.getAll(jobName, jobId + JOB_STATE_STORE_TABLE_SUFFIX);
        if (jobStates.isEmpty()) {
            LOGGER.warn(String.format("No job state found for job with name %s and id %s", jobName, jobId));
            return;
        }
        try (JsonWriter jsonWriter = new JsonWriter(writer);){
            jsonWriter.setIndent("\t");
            this.writeJobState(jsonWriter, (JobState)((Object)jobStates.get(0)));
        }
    }

    public void convert(String jobName, Writer writer) throws IOException {
        this.convert(jobName, "current", writer);
    }

    public void convertAll(String jobName, Writer writer) throws IOException {
        List jobStates = this.jobStateStore.getAll(jobName);
        if (jobStates.isEmpty()) {
            LOGGER.warn(String.format("No job state found for job with name %s", jobName));
            return;
        }
        try (JsonWriter jsonWriter = new JsonWriter(writer);){
            jsonWriter.setIndent("\t");
            this.writeJobStates(jsonWriter, jobStates);
        }
    }

    private void writeJobState(JsonWriter jsonWriter, JobState jobState) throws IOException {
        jobState.toJson(jsonWriter, this.keepConfig);
    }

    private void writeJobStates(JsonWriter jsonWriter, List<? extends JobState> jobStates) throws IOException {
        jsonWriter.beginArray();
        for (JobState jobState : jobStates) {
            this.writeJobState(jsonWriter, jobState);
        }
        jsonWriter.endArray();
    }

    public static void main(String[] args) throws Exception {
        Option sysConfigOption = Option.builder((String)"sc").argName("system configuration file").desc("Gobblin system configuration file (required if no state store URL specified)").longOpt("sysconfig").hasArg().build();
        Option storeUrlOption = Option.builder((String)"u").argName("gobblin state store URL").desc("Gobblin state store root path URL (required if no sysconfig specified)").longOpt("storeurl").hasArg().build();
        Option jobNameOption = Option.builder((String)"n").argName("gobblin job name").desc("Gobblin job name (required)").longOpt("name").hasArg().required().build();
        Option jobIdOption = Option.builder((String)"i").argName("gobblin job id").desc("Gobblin job id").longOpt("id").hasArg().build();
        Option convertAllOption = Option.builder((String)"a").desc("Whether to convert all past job states of the given job").longOpt("all").build();
        Option keepConfigOption = Option.builder((String)"kc").desc("Whether to keep all configuration properties").longOpt("keepConfig").build();
        Option outputToFile = Option.builder((String)"t").argName("output file name").desc("Output file name").longOpt("toFile").hasArg().build();
        Options options = new Options();
        options.addOption(sysConfigOption);
        options.addOption(storeUrlOption);
        options.addOption(jobNameOption);
        options.addOption(jobIdOption);
        options.addOption(convertAllOption);
        options.addOption(keepConfigOption);
        options.addOption(outputToFile);
        CommandLine cmd = null;
        try {
            DefaultParser parser = new DefaultParser();
            cmd = parser.parse(options, args);
        }
        catch (ParseException pe) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("JobStateToJsonConverter", options);
            System.exit(1);
        }
        if (!cmd.hasOption(sysConfigOption.getLongOpt()) && !cmd.hasOption(storeUrlOption.getLongOpt())) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("JobStateToJsonConverter", options);
            System.exit(1);
        }
        Properties sysConfig = new Properties();
        if (cmd.hasOption(sysConfigOption.getLongOpt())) {
            sysConfig = JobConfigurationUtils.fileToProperties((String)cmd.getOptionValue(sysConfigOption.getLongOpt()));
        }
        JobStateToJsonConverter converter = new JobStateToJsonConverter(sysConfig, cmd.getOptionValue('u'), cmd.hasOption("kc"));
        StringWriter stringWriter = new StringWriter();
        if (cmd.hasOption('i')) {
            converter.convert(cmd.getOptionValue('n'), cmd.getOptionValue('i'), stringWriter);
        } else if (cmd.hasOption('a')) {
            converter.convertAll(cmd.getOptionValue('n'), stringWriter);
        } else {
            converter.convert(cmd.getOptionValue('n'), stringWriter);
        }
        if (cmd.hasOption('t')) {
            try (Closer closer = Closer.create();){
                FileOutputStream fileOutputStream = (FileOutputStream)closer.register((Closeable)new FileOutputStream(cmd.getOptionValue('t')));
                OutputStreamWriter outputStreamWriter = (OutputStreamWriter)closer.register((Closeable)new OutputStreamWriter((OutputStream)fileOutputStream, ConfigurationKeys.DEFAULT_CHARSET_ENCODING));
                BufferedWriter bufferedWriter = (BufferedWriter)closer.register((Closeable)new BufferedWriter(outputStreamWriter));
                bufferedWriter.write(stringWriter.toString());
            }
        } else {
            System.out.println(stringWriter.toString());
        }
    }
}

