/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.monitoring;

import java.util.Iterator;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.service.monitoring.FlowStatus;
import org.apache.gobblin.service.monitoring.JobStatus;
import org.apache.gobblin.service.monitoring.JobStatusRetriever;

@Alpha
public class FlowStatusGenerator {
    private final JobStatusRetriever jobStatusRetriever;

    public FlowStatus getLatestFlowStatus(String flowName, String flowGroup) {
        FlowStatus flowStatus = null;
        long latestExecutionId = this.jobStatusRetriever.getLatestExecutionIdForFlow(flowName, flowGroup);
        if (latestExecutionId != -1L) {
            flowStatus = this.getFlowStatus(flowName, flowGroup, latestExecutionId);
        }
        return flowStatus;
    }

    public FlowStatus getFlowStatus(String flowName, String flowGroup, long flowExecutionId) {
        FlowStatus flowStatus = null;
        Iterator<JobStatus> jobStatusIterator = this.jobStatusRetriever.getJobStatusesForFlowExecution(flowName, flowGroup, flowExecutionId);
        if (jobStatusIterator.hasNext()) {
            flowStatus = new FlowStatus(flowName, flowGroup, flowExecutionId, jobStatusIterator);
        }
        return flowStatus;
    }

    FlowStatusGenerator(JobStatusRetriever jobStatusRetriever) {
        this.jobStatusRetriever = jobStatusRetriever;
    }

    public static FlowStatusGeneratorBuilder builder() {
        return new FlowStatusGeneratorBuilder();
    }

    public static class FlowStatusGeneratorBuilder {
        private JobStatusRetriever jobStatusRetriever;

        FlowStatusGeneratorBuilder() {
        }

        public FlowStatusGeneratorBuilder jobStatusRetriever(JobStatusRetriever jobStatusRetriever) {
            this.jobStatusRetriever = jobStatusRetriever;
            return this;
        }

        public FlowStatusGenerator build() {
            return new FlowStatusGenerator(this.jobStatusRetriever);
        }

        public String toString() {
            return "FlowStatusGenerator.FlowStatusGeneratorBuilder(jobStatusRetriever=" + this.jobStatusRetriever + ")";
        }
    }
}

