/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.instrumented.fork;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.fork.ForkOperator;
import org.apache.gobblin.instrumented.Instrumentable;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;

abstract class InstrumentedForkOperatorBase<S, D>
implements Instrumentable,
ForkOperator<S, D> {
    private boolean instrumentationEnabled;
    private MetricContext metricContext;
    private Optional<Class<?>> classTag;
    private Optional<Meter> inputMeter;
    private Optional<Meter> outputForks;
    private Optional<Timer> forkOperatorTimer;
    protected final Closer closer = Closer.create();

    public InstrumentedForkOperatorBase() {
        this(Optional.absent());
    }

    protected InstrumentedForkOperatorBase(Optional<Class<?>> classTag) {
        this.classTag = classTag;
        this.regenerateMetrics();
    }

    public void init(WorkUnitState workUnitState) throws Exception {
        this.init(workUnitState, this.getClass());
    }

    protected void init(WorkUnitState workUnitState, Class<?> classTag) throws Exception {
        this.instrumentationEnabled = GobblinMetrics.isEnabled((State)workUnitState);
        this.metricContext = (MetricContext)this.closer.register((Closeable)Instrumented.getMetricContext((State)workUnitState, (Class)this.classTag.or(classTag)));
        this.regenerateMetrics();
    }

    @Override
    public void switchMetricContext(List<Tag<?>> tags) {
        this.metricContext = (MetricContext)this.closer.register((Closeable)Instrumented.newContextFromReferenceContext(this.metricContext, tags, (Optional<String>)Optional.absent()));
        this.regenerateMetrics();
    }

    @Override
    public void switchMetricContext(MetricContext context) {
        this.metricContext = context;
        this.regenerateMetrics();
    }

    protected void regenerateMetrics() {
        if (this.isInstrumentationEnabled()) {
            this.inputMeter = Optional.of((Object)this.metricContext.meter("gobblin.fork.operator.records.in"));
            this.outputForks = Optional.of((Object)this.metricContext.meter("gobblin.fork.operator.forks.out"));
            this.forkOperatorTimer = Optional.of((Object)this.metricContext.timer("gobblin.fork.operator.fork.time"));
        } else {
            this.inputMeter = Optional.absent();
            this.outputForks = Optional.absent();
            this.forkOperatorTimer = Optional.absent();
        }
    }

    @Override
    public List<Tag<?>> generateTags(State state) {
        return Lists.newArrayList();
    }

    @Override
    public boolean isInstrumentationEnabled() {
        return this.instrumentationEnabled;
    }

    public List<Boolean> forkDataRecord(WorkUnitState workUnitState, D input) {
        if (!this.isInstrumentationEnabled()) {
            return this.forkDataRecordImpl(workUnitState, input);
        }
        long startTimeNanos = System.nanoTime();
        this.beforeFork(input);
        List<Boolean> result = this.forkDataRecordImpl(workUnitState, input);
        this.afterFork(result, startTimeNanos);
        return result;
    }

    protected void beforeFork(D input) {
        Instrumented.markMeter(this.inputMeter);
    }

    protected void afterFork(List<Boolean> forks, long startTimeNanos) {
        int forksGenerated = 0;
        for (Boolean fork : forks) {
            forksGenerated += fork != false ? 1 : 0;
        }
        Instrumented.markMeter(this.outputForks, forksGenerated);
        Instrumented.updateTimer(this.forkOperatorTimer, System.nanoTime() - startTimeNanos, TimeUnit.NANOSECONDS);
    }

    public abstract List<Boolean> forkDataRecordImpl(WorkUnitState var1, D var2);

    @Override
    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public void close() throws IOException {
        this.closer.close();
    }
}

