/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract;

import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import com.google.common.primitives.Longs;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.math.RoundingMode;
import org.apache.gobblin.source.extractor.ComparableWatermark;
import org.apache.gobblin.source.extractor.Watermark;

public class LongWatermark
implements ComparableWatermark {
    private static final Gson GSON = new Gson();
    private long value;

    public LongWatermark(long value) {
        this.value = value;
    }

    public void increment() {
        ++this.value;
    }

    public JsonElement toJson() {
        return GSON.toJsonTree((Object)this);
    }

    public short calculatePercentCompletion(Watermark lowWatermark, Watermark highWatermark) {
        Preconditions.checkArgument((boolean)(lowWatermark instanceof LongWatermark));
        Preconditions.checkArgument((boolean)(highWatermark instanceof LongWatermark));
        long total = ((LongWatermark)highWatermark).value - ((LongWatermark)lowWatermark).value;
        long pulled = this.value - ((LongWatermark)lowWatermark).value;
        Preconditions.checkState((total >= 0L ? 1 : 0) != 0);
        Preconditions.checkState((pulled >= 0L ? 1 : 0) != 0);
        if (total == 0L) {
            return 0;
        }
        long percent = Math.min(100L, LongMath.divide((long)(pulled * 100L), (long)total, (RoundingMode)RoundingMode.HALF_UP));
        return (short)percent;
    }

    public int compareTo(ComparableWatermark other) {
        Preconditions.checkArgument((boolean)(other instanceof LongWatermark));
        return Longs.compare((long)this.value, (long)((LongWatermark)other).value);
    }

    public String toString() {
        return "LongWatermark(value=" + this.getValue() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongWatermark)) {
            return false;
        }
        LongWatermark other = (LongWatermark)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getValue() == other.getValue();
    }

    protected boolean canEqual(Object other) {
        return other instanceof LongWatermark;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = this.getValue();
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }
}

