/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.io.Closeable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.writer.Batch;
import org.apache.gobblin.writer.RecordMetadata;
import org.apache.gobblin.writer.WriteCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public abstract class BatchAccumulator<D>
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BatchAccumulator.class);
    private volatile boolean closed = false;
    private CountDownLatch closeComplete;
    private final AtomicInteger appendsInProgress = new AtomicInteger(0);

    protected BatchAccumulator() {
        this.closeComplete = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Future<RecordMetadata> append(D record, WriteCallback callback) throws InterruptedException {
        this.appendsInProgress.incrementAndGet();
        try {
            if (this.closed) {
                throw new RuntimeException("Cannot append after accumulator has been closed");
            }
            Future<RecordMetadata> future = this.enqueue(record, callback);
            return future;
        }
        finally {
            this.appendsInProgress.decrementAndGet();
        }
    }

    public final void waitClose() {
        try {
            this.closeComplete.await();
        }
        catch (InterruptedException e) {
            LOG.error("accumulator close is interrupted");
        }
        LOG.info("accumulator is closed");
    }

    public boolean isClosed() {
        return this.closed;
    }

    public abstract Future<RecordMetadata> enqueue(D var1, WriteCallback var2) throws InterruptedException;

    public abstract void flush();

    @Override
    public void close() {
        this.closed = true;
        while (this.appendsInProgress.get() > 0) {
            LOG.info("Append is still going on, wait for a while");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.error("close is interrupted while appending data is in progress");
            }
        }
        this.closeComplete.countDown();
    }

    public abstract void deallocate(Batch<D> var1);

    public abstract Batch<D> getNextAvailableBatch();
}

