/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.caprep.db;

import com.linkedin.r2.caprep.db.DbSource;
import com.linkedin.r2.caprep.db.DirectoryDbUtil;
import com.linkedin.r2.caprep.db.MessageSerializer;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryDbSource
implements DbSource {
    private static final Logger _log = LoggerFactory.getLogger(DirectoryDbSource.class);
    private final Map<RestRequest, RestResponse> _db;
    private final MessageSerializer _serializer;

    public DirectoryDbSource(String dir, MessageSerializer serializer) throws IOException {
        this(new File(dir), serializer);
    }

    public DirectoryDbSource(File dir, MessageSerializer serializer) throws IOException {
        this._db = this.loadDb(dir, serializer);
        this._serializer = serializer;
    }

    @Override
    public RestResponse replay(RestRequest req) {
        try {
            return this._db.get(this.canonicalize(req));
        }
        catch (Exception e) {
            _log.debug("Failed to canonicalize request: " + req, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<RestRequest, RestResponse> loadDb(File dir, MessageSerializer serializer) throws IOException {
        HashMap<RestRequest, RestResponse> db = new HashMap<RestRequest, RestResponse>();
        Object[] ids = DirectoryDbUtil.listRequestIds(dir);
        Arrays.sort(ids);
        for (Object id : ids) {
            FileInputStream reqIn = null;
            FileInputStream resIn = null;
            try {
                reqIn = new FileInputStream(DirectoryDbUtil.requestFileName(dir, (String)id));
                RestRequest req = serializer.readRestRequest(reqIn);
                resIn = new FileInputStream(DirectoryDbUtil.responseFileName(dir, (String)id));
                RestResponse res = serializer.readRestResponse(resIn);
                db.put(this.canonicalize(req), res);
                this.closeSilently(reqIn);
                this.closeSilently(resIn);
            }
            catch (IOException e) {
                try {
                    _log.warn("Failed to parse request or response for: " + (String)id, (Throwable)e);
                    this.closeSilently(reqIn);
                    this.closeSilently(resIn);
                }
                catch (Throwable throwable) {
                    this.closeSilently(reqIn);
                    this.closeSilently(resIn);
                    throw throwable;
                }
            }
        }
        return db;
    }

    private RestRequest canonicalize(RestRequest req) {
        return req.builder().buildCanonical();
    }

    private void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

