/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.message.stream;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.filter.NextFilter;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.filter.message.stream.StreamFilter;
import com.linkedin.r2.message.Messages;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamException;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import java.util.Map;

public class StreamFilterAdapters {
    private StreamFilterAdapters() {
    }

    public static StreamFilter adaptRestFilter(RestFilter filter) {
        return new StreamFilterAdapter(filter);
    }

    private static class AdaptingNextFilter
    implements NextFilter<RestRequest, RestResponse> {
        private final NextFilter<StreamRequest, StreamResponse> _nextFilter;

        AdaptingNextFilter(NextFilter<StreamRequest, StreamResponse> nextFilter) {
            this._nextFilter = nextFilter;
        }

        @Override
        public void onRequest(RestRequest req, RequestContext requestContext, Map<String, String> wireAttrs) {
            StreamRequest streamRequest = Messages.toStreamRequest(req);
            this._nextFilter.onRequest(streamRequest, requestContext, wireAttrs);
        }

        @Override
        public void onResponse(RestResponse res, RequestContext requestContext, Map<String, String> wireAttrs) {
            StreamResponse streamResponse = Messages.toStreamResponse(res);
            this._nextFilter.onResponse(streamResponse, requestContext, wireAttrs);
        }

        @Override
        public void onError(Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs) {
            if (ex instanceof RestException) {
                StreamException streamException = Messages.toStreamException((RestException)ex);
                this._nextFilter.onError(streamException, requestContext, wireAttrs);
            } else {
                this._nextFilter.onError(ex, requestContext, wireAttrs);
            }
        }
    }

    private static class StreamFilterAdapter
    implements StreamFilter {
        RestFilter _filter;

        public StreamFilterAdapter(RestFilter filter) {
            this._filter = filter;
        }

        @Override
        public void onStreamRequest(StreamRequest req, final RequestContext requestContext, final Map<String, String> wireAttrs, final NextFilter<StreamRequest, StreamResponse> nextFilter) {
            Messages.toRestRequest(req, new Callback<RestRequest>(){

                public void onError(Throwable e) {
                    nextFilter.onError(e, requestContext, wireAttrs);
                }

                public void onSuccess(RestRequest result) {
                    _filter.onRestRequest(result, requestContext, wireAttrs, new AdaptingNextFilter(nextFilter));
                }
            });
        }

        @Override
        public void onStreamResponse(StreamResponse res, final RequestContext requestContext, final Map<String, String> wireAttrs, final NextFilter<StreamRequest, StreamResponse> nextFilter) {
            Messages.toRestResponse(res, new Callback<RestResponse>(){

                public void onError(Throwable e) {
                    nextFilter.onError(e, requestContext, wireAttrs);
                }

                public void onSuccess(RestResponse result) {
                    _filter.onRestResponse(result, requestContext, wireAttrs, new AdaptingNextFilter(nextFilter));
                }
            });
        }

        @Override
        public void onStreamError(Throwable ex, final RequestContext requestContext, final Map<String, String> wireAttrs, final NextFilter<StreamRequest, StreamResponse> nextFilter) {
            if (ex instanceof StreamException) {
                Messages.toRestException((StreamException)ex, new Callback<RestException>(){

                    public void onError(Throwable e) {
                        nextFilter.onError(e, requestContext, wireAttrs);
                    }

                    public void onSuccess(RestException result) {
                        _filter.onRestError(result, requestContext, wireAttrs, new AdaptingNextFilter(nextFilter));
                    }
                });
            } else {
                this._filter.onRestError(ex, requestContext, wireAttrs, new AdaptingNextFilter(nextFilter));
            }
        }
    }
}

