/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.transport;

import com.linkedin.r2.filter.NextFilter;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.filter.message.stream.StreamFilter;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.Response;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import java.util.HashMap;
import java.util.Map;

public class ClientRequestFilter
implements StreamFilter,
RestFilter {
    private final TransportClient _client;

    public ClientRequestFilter(TransportClient client) {
        this._client = client;
    }

    @Override
    public void onRestRequest(RestRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        try {
            this._client.restRequest(req, requestContext, wireAttrs, this.createCallback(requestContext, nextFilter));
        }
        catch (Exception e) {
            nextFilter.onError(e, requestContext, new HashMap<String, String>());
        }
    }

    @Override
    public void onStreamRequest(StreamRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
        try {
            this._client.streamRequest(req, requestContext, wireAttrs, this.createCallback(requestContext, nextFilter));
        }
        catch (Exception e) {
            nextFilter.onError(e, requestContext, new HashMap<String, String>());
        }
    }

    private <REQ extends Request, RES extends Response> TransportCallback<RES> createCallback(final RequestContext requestContext, final NextFilter<REQ, RES> nextFilter) {
        return new TransportCallback<RES>(){

            @Override
            public void onResponse(TransportResponse<RES> res) {
                HashMap<String, String> wireAttrs = new HashMap<String, String>(res.getWireAttributes());
                if (res.hasError()) {
                    nextFilter.onError(res.getError(), requestContext, wireAttrs);
                } else {
                    nextFilter.onResponse((Response)res.getResponse(), requestContext, wireAttrs);
                }
            }
        };
    }
}

