/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message.stream.entitystream;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.stream.entitystream.CancelingReader;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import com.linkedin.r2.message.stream.entitystream.EntityStreams;
import com.linkedin.r2.message.stream.entitystream.ReadHandle;
import com.linkedin.r2.message.stream.entitystream.Reader;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import com.linkedin.r2.message.stream.entitystream.Writer;
import java.util.Arrays;
import java.util.Iterator;

public class CompositeWriter
implements Writer {
    private Iterator<EntityStream> _entityStreams;
    private WriteHandle _wh;
    private int _outstanding;
    private boolean _aborted = false;
    private ReadHandle _currentRh;
    private ReaderImpl _reader = new ReaderImpl();

    public CompositeWriter(Writer ... writers) {
        this(CompositeWriter.toEntityStreams(writers));
    }

    public CompositeWriter(EntityStream ... entityStreams) {
        this(Arrays.asList(entityStreams));
    }

    public CompositeWriter(Iterable<EntityStream> entityStreams) {
        this._entityStreams = entityStreams.iterator();
        this._outstanding = 0;
    }

    @Override
    public void onInit(WriteHandle wh) {
        this._wh = wh;
        this.readNextStream();
    }

    @Override
    public void onWritePossible() {
        this._outstanding = this._wh.remaining();
        this._currentRh.request(this._outstanding);
    }

    @Override
    public void onAbort(Throwable e) {
        this._aborted = true;
        this._currentRh.cancel();
        this.cancelAll();
    }

    private void readNextStream() {
        if (this._entityStreams.hasNext()) {
            EntityStream stream = this._entityStreams.next();
            stream.setReader(this._reader);
        } else {
            this._wh.done();
        }
    }

    private void cancelAll() {
        while (this._entityStreams.hasNext()) {
            EntityStream stream = this._entityStreams.next();
            stream.setReader(new CancelingReader());
        }
    }

    private static EntityStream[] toEntityStreams(Writer ... writers) {
        EntityStream[] entityStreams = new EntityStream[writers.length];
        for (int i = 0; i < writers.length; ++i) {
            entityStreams[i] = EntityStreams.newEntityStream(writers[i]);
        }
        return entityStreams;
    }

    private class ReaderImpl
    implements Reader {
        private ReaderImpl() {
        }

        @Override
        public void onInit(ReadHandle rh) {
            CompositeWriter.this._currentRh = rh;
            if (CompositeWriter.this._outstanding > 0) {
                CompositeWriter.this._currentRh.request(CompositeWriter.this._outstanding);
            }
        }

        @Override
        public void onDataAvailable(ByteString data) {
            if (!CompositeWriter.this._aborted) {
                CompositeWriter.this._wh.write(data);
                CompositeWriter.this._outstanding--;
                int diff = CompositeWriter.this._wh.remaining() - CompositeWriter.this._outstanding;
                if (diff > 0) {
                    CompositeWriter.this._currentRh.request(diff);
                    CompositeWriter.this._outstanding = CompositeWriter.this._outstanding + diff;
                }
            }
        }

        @Override
        public void onDone() {
            if (!CompositeWriter.this._aborted) {
                CompositeWriter.this.readNextStream();
            }
        }

        @Override
        public void onError(Throwable e) {
            CompositeWriter.this._wh.error(e);
            CompositeWriter.this.cancelAll();
        }
    }
}

