/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message.stream.entitystream;

import com.linkedin.common.callback.Callback;
import com.linkedin.data.ByteString;
import com.linkedin.r2.message.stream.entitystream.ReadHandle;
import com.linkedin.r2.message.stream.entitystream.Reader;

public final class FullEntityReader
implements Reader {
    private final ByteString.Builder _builder;
    private final Callback<ByteString> _callback;
    private ReadHandle _rh;

    public FullEntityReader(Callback<ByteString> callback) {
        this._callback = callback;
        this._builder = new ByteString.Builder();
    }

    @Override
    public void onInit(ReadHandle rh) {
        this._rh = rh;
        this._rh.request(10);
    }

    @Override
    public void onDataAvailable(ByteString data) {
        this._builder.append(data);
        this._rh.request(1);
    }

    @Override
    public void onDone() {
        ByteString entity = this._builder.build();
        this._callback.onSuccess((Object)entity);
    }

    @Override
    public void onError(Throwable ex) {
        this._callback.onError(ex);
    }
}

