/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.common;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.message.Messages;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.RestRequestHandler;
import com.linkedin.r2.transport.common.StreamRequestHandler;

public class StreamRequestHandlerAdapter
implements StreamRequestHandler {
    private final RestRequestHandler _restRequestHandler;

    public StreamRequestHandlerAdapter(RestRequestHandler restRequestHandler) {
        this._restRequestHandler = restRequestHandler;
    }

    @Override
    public void handleRequest(StreamRequest request, final RequestContext requestContext, final Callback<StreamResponse> callback) {
        Messages.toRestRequest(request, new Callback<RestRequest>(){

            public void onError(Throwable e) {
                callback.onError(e);
            }

            public void onSuccess(RestRequest restRequest) {
                StreamRequestHandlerAdapter.this._restRequestHandler.handleRequest(restRequest, requestContext, Messages.toRestCallback((Callback<StreamResponse>)callback));
            }
        });
    }
}

