/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.common.stats.LongStats;
import com.linkedin.common.stats.LongTracking;
import com.linkedin.r2.transport.http.client.AsyncPoolStats;
import com.linkedin.r2.transport.http.client.PoolStats;
import java.util.function.Supplier;

public class AsyncPoolStatsTracker {
    private int _totalCreated = 0;
    private int _totalDestroyed = 0;
    private int _totalCreateErrors = 0;
    private int _totalDestroyErrors = 0;
    private int _totalBadDestroyed = 0;
    private int _totalTimedOut = 0;
    private int _sampleMaxCheckedOut = 0;
    private int _sampleMaxPoolSize = 0;
    private final Supplier<PoolStats.LifecycleStats> _lifecycleStatsSupplier;
    private final Supplier<Integer> _maxSizeSupplier;
    private final Supplier<Integer> _minSizeSupplier;
    private final Supplier<Integer> _poolSizeSupplier;
    private final Supplier<Integer> _checkedOutSupplier;
    private final Supplier<Integer> _idleSizeSupplier;
    private final LongTracking _waitTimeTracker;

    public AsyncPoolStatsTracker(Supplier<PoolStats.LifecycleStats> lifecycleStatsSupplier, Supplier<Integer> maxSizeSupplier, Supplier<Integer> minSizeSupplier, Supplier<Integer> poolSizeSupplier, Supplier<Integer> checkedOutSupplier, Supplier<Integer> idleSizeSupplier) {
        this._lifecycleStatsSupplier = lifecycleStatsSupplier;
        this._maxSizeSupplier = maxSizeSupplier;
        this._minSizeSupplier = minSizeSupplier;
        this._poolSizeSupplier = poolSizeSupplier;
        this._checkedOutSupplier = checkedOutSupplier;
        this._idleSizeSupplier = idleSizeSupplier;
        this._waitTimeTracker = new LongTracking();
    }

    public void incrementCreated() {
        ++this._totalCreated;
    }

    public void incrementDestroyed() {
        ++this._totalDestroyed;
    }

    public void incrementCreateErrors() {
        ++this._totalCreateErrors;
    }

    public void incrementDestroyErrors() {
        ++this._totalDestroyErrors;
    }

    public void incrementBadDestroyed() {
        ++this._totalBadDestroyed;
    }

    public void incrementTimedOut() {
        ++this._totalTimedOut;
    }

    public void sampleMaxPoolSize() {
        this._sampleMaxPoolSize = Math.max(this._poolSizeSupplier.get(), this._sampleMaxPoolSize);
    }

    public void sampleMaxCheckedOut() {
        this._sampleMaxCheckedOut = Math.max(this._checkedOutSupplier.get(), this._sampleMaxCheckedOut);
    }

    public void trackWaitTime(long waitTimeMillis) {
        this._waitTimeTracker.addValue(waitTimeMillis);
    }

    public AsyncPoolStats getStats() {
        LongStats waitTimeStats = this._waitTimeTracker.getStats();
        AsyncPoolStats stats = new AsyncPoolStats(this._totalCreated, this._totalDestroyed, this._totalCreateErrors, this._totalDestroyErrors, this._totalBadDestroyed, this._totalTimedOut, this._checkedOutSupplier.get(), this._maxSizeSupplier.get(), this._minSizeSupplier.get(), this._poolSizeSupplier.get(), this._sampleMaxCheckedOut, this._sampleMaxPoolSize, this._idleSizeSupplier.get(), waitTimeStats.getAverage(), waitTimeStats.get50Pct(), waitTimeStats.get95Pct(), waitTimeStats.get99Pct(), this._lifecycleStatsSupplier.get());
        this._sampleMaxCheckedOut = this._checkedOutSupplier.get();
        this._sampleMaxPoolSize = this._poolSizeSupplier.get();
        this._waitTimeTracker.reset();
        return stats;
    }
}

