/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.SimpleCallback;
import com.linkedin.common.util.None;
import com.linkedin.r2.SizeLimitExceededException;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.AsyncPoolStatsTracker;
import com.linkedin.r2.transport.http.client.PoolStats;
import com.linkedin.r2.transport.http.client.RateLimiter;
import com.linkedin.r2.util.Cancellable;
import com.linkedin.r2.util.LinkedDeque;
import com.linkedin.util.ArgumentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSharedPoolImpl<T>
implements AsyncPool<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncSharedPoolImpl.class);
    private static final boolean BAD = true;
    private static final boolean NOT_BAD = false;
    private final String _name;
    private final AsyncPool.Lifecycle<T> _lifecycle;
    private final ScheduledExecutorService _scheduler;
    private final RateLimiter _rateLimiter;
    private final long _timeoutMills;
    private final int _maxWaiters;
    private volatile ScheduledFuture<?> _reaperTaskFuture = null;
    private final Object _lock = new Object();
    private final TimedObject<T> _item;
    private int _checkedOut = 0;
    private final HashMap<T, Integer> _disposedItems = new HashMap();
    private final AsyncPoolStatsTracker _statsTracker;
    private final LinkedDeque<Callback<T>> _waiters;
    private State _state = State.NOT_YET_STARTED;
    private Callback<None> _shutdownCallback = null;
    private boolean _isCreateInProgress = false;
    private final HashSet<T> _destroyInProgress = new HashSet();

    public AsyncSharedPoolImpl(String name, AsyncPool.Lifecycle<T> lifecycle, ScheduledExecutorService scheduler, RateLimiter rateLimiter, long timeoutMills, int maxWaiters) {
        ArgumentUtil.notNull((Object)name, (String)"name");
        ArgumentUtil.notNull(lifecycle, (String)"lifecycle");
        ArgumentUtil.notNull((Object)scheduler, (String)"scheduler");
        ArgumentUtil.notNull((Object)rateLimiter, (String)"rateLimiter");
        this._name = name;
        this._lifecycle = lifecycle;
        this._scheduler = scheduler;
        this._rateLimiter = rateLimiter;
        this._timeoutMills = timeoutMills;
        this._maxWaiters = maxWaiters;
        this._item = new TimedObject();
        this._statsTracker = new AsyncPoolStatsTracker(() -> this._lifecycle.getStats(), () -> 1, () -> 0, () -> {
            Object object = this._lock;
            synchronized (object) {
                return this._item.get() == null ? 0 : 1;
            }
        }, () -> {
            Object object = this._lock;
            synchronized (object) {
                return this._checkedOut;
            }
        }, () -> {
            Object object = this._lock;
            synchronized (object) {
                if (this._checkedOut > 0) {
                    return 0;
                }
                return this._item.get() == null ? 0 : 1;
            }
        });
        this._waiters = new LinkedDeque();
    }

    @Override
    public String getName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        LOG.info("{}: start requested", (Object)this._name);
        Object object = this._lock;
        synchronized (object) {
            if (this._state != State.NOT_YET_STARTED) {
                throw new IllegalStateException(this._name + " is " + (Object)((Object)this._state));
            }
            this._state = State.RUNNING;
            if (this._timeoutMills > 0L) {
                long freq = Math.min(this._timeoutMills / 10L, 1000L);
                this._reaperTaskFuture = this._scheduler.scheduleAtFixedRate(() -> this.reap(), freq, freq, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(Callback<None> callback) {
        State state;
        ArgumentUtil.notNull(callback, (String)"callback");
        LOG.info("{}: shutdown requested", (Object)this._name);
        Object object = this._lock;
        synchronized (object) {
            state = this._state;
            if (state == State.RUNNING) {
                this._state = State.SHUTTING_DOWN;
                this._shutdownCallback = callback;
            }
        }
        if (state != State.RUNNING) {
            LOG.error("{}: shutdown requested while pool is not running", (Object)this._name);
            callback.onError((Throwable)new IllegalStateException(this._name + " is " + (Object)((Object)this._state)));
            return;
        }
        this.doAttemptShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Callback<T>> cancelWaiters() {
        Object object = this._lock;
        synchronized (object) {
            Callback item;
            ArrayList<Callback<T>> cancelled = new ArrayList<Callback<T>>(this._waiters.size());
            while ((item = (Callback)this._waiters.poll()) != null) {
                cancelled.add(item);
            }
            return cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cancellable get(Callback<T> callback) {
        LinkedDeque.Node<TimeTrackingCallback> node;
        ArgumentUtil.notNull(callback, (String)"callback");
        TimeTrackingCallback timeTrackingCallback = new TimeTrackingCallback(callback);
        T item = null;
        boolean create = false;
        while (true) {
            boolean disposed;
            State state;
            Object object = this._lock;
            synchronized (object) {
                state = this._state;
                if (state == State.RUNNING) {
                    item = this._item.get();
                    if (item == null) {
                        LinkedDeque.Node<TimeTrackingCallback> node2 = node = this._waiters.size() < this._maxWaiters ? this._waiters.addLastNode(timeTrackingCallback) : null;
                        if (this._isCreateInProgress) {
                            LOG.debug("{}: item creation is in progress", (Object)this._name);
                        } else {
                            this._isCreateInProgress = true;
                            create = true;
                        }
                        break;
                    }
                    ++this._checkedOut;
                    this._statsTracker.sampleMaxCheckedOut();
                }
            }
            if (state != State.RUNNING) {
                timeTrackingCallback.onError(new IllegalStateException(this._name + " is " + (Object)((Object)this._state)));
                return () -> false;
            }
            if (this._lifecycle.validateGet(item)) {
                timeTrackingCallback.onSuccess(item);
                return () -> false;
            }
            Object object2 = this._lock;
            synchronized (object2) {
                disposed = this.doDispose(item);
            }
            if (!disposed) continue;
            this.doDestroy(item, true, () -> {});
        }
        if (node == null) {
            timeTrackingCallback.onError(new SizeLimitExceededException("AsyncPool " + this._name + " reached maximum waiter size: " + this._maxWaiters));
            return () -> false;
        }
        if (create) {
            this.doCreate();
        }
        return () -> {
            Object object = this._lock;
            synchronized (object) {
                return this._waiters.removeNode(node) != null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T item) {
        LOG.debug("{}: putting back an item {}", (Object)this._name, item);
        boolean disposed = false;
        boolean returned = false;
        Object object = this._lock;
        synchronized (object) {
            if (this._item.get() == null || this._item.get() != item) {
                LOG.debug("{}: given item {} does not reference match current item {}", new Object[]{this._name, item, this._item.get()});
                disposed = this.doDispose(item);
            } else if (this._lifecycle.validatePut(item)) {
                LOG.debug("{}: returning an item {} that passed validation", (Object)this._name, item);
                returned = this.doReturn(item);
            } else {
                LOG.debug("{}: disposing an item {} that failed validation", (Object)this._name, item);
                disposed = this.doDispose(item);
            }
        }
        if (disposed) {
            this.doDestroy(item, true, () -> this.doAttemptShutdown());
        }
        if (returned) {
            this.doAttemptShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(T item) {
        boolean disposed;
        LOG.error("{}: disposing an item {}", (Object)this._name, item);
        Object object = this._lock;
        synchronized (object) {
            disposed = this.doDispose(item);
        }
        if (disposed) {
            this.doDestroy(item, true, () -> this.doAttemptShutdown());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolStats getStats() {
        Object object = this._lock;
        synchronized (object) {
            return this._statsTracker.getStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reap() {
        T item;
        Object object = this._lock;
        synchronized (object) {
            item = this._item.get();
            if (item == null) {
                LOG.debug("{}: nothing to reap", (Object)this._name);
                return;
            }
            if (this._checkedOut > 0) {
                LOG.debug("{}: item still has {} outstanding checkouts", (Object)this._name, (Object)this._checkedOut);
                this._item.renew();
                return;
            }
            if (!this._item.expired()) {
                LOG.debug("{}: item is still valid", (Object)this._name);
                return;
            }
            this._statsTracker.incrementTimedOut();
            this._item.reset();
        }
        LOG.debug("{}: item timed out, proceed to destroy", (Object)this._name);
        this.doDestroy(item, false, () -> this.doAttemptShutdown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doReturn(T item) {
        this._rateLimiter.setPeriod(0L);
        Object object = this._lock;
        synchronized (object) {
            if (this._item.get() == null || this._item.get() != item) {
                LOG.debug("{}: given item {} does not reference match current item {}", new Object[]{this._name, item, this._item.get()});
                throw new IllegalArgumentException("Returning an item that is not the same as the current active item");
            }
            if (this._checkedOut == 0) {
                throw new IllegalArgumentException("Decrementing checked out when it's already at 0");
            }
            --this._checkedOut;
            return this._checkedOut == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAttemptShutdown() {
        ScheduledFuture<?> reaperTaskFuture;
        Callback<None> shutdownCallback;
        LOG.debug("{}: attempts to shutdown", (Object)this._name);
        Object object = this._lock;
        synchronized (object) {
            shutdownCallback = this._shutdownCallback;
            reaperTaskFuture = this._reaperTaskFuture;
            if (this._state != State.SHUTTING_DOWN) {
                LOG.debug("{}: current state is {}", (Object)this._name, (Object)this._state);
                return;
            }
            if (this._checkedOut > 0) {
                LOG.info("{}: awaiting {} more outstanding checkouts", (Object)this._name, (Object)this._checkedOut);
                return;
            }
            if (this._disposedItems.size() > 0) {
                LOG.info("{}: awaiting {} more disposed items {}", new Object[]{this._name, this._disposedItems.keySet().size(), this._disposedItems});
                return;
            }
            LOG.info("{}: shutdown conditions are met", (Object)this._name);
            this._state = State.STOPPED;
            this._shutdownCallback = null;
            this._reaperTaskFuture = null;
        }
        if (reaperTaskFuture != null) {
            LOG.debug("{}: attempt to cancel reaper task", (Object)this._name);
            reaperTaskFuture.cancel(false);
        }
        LOG.info("{}: shutdown complete", (Object)this._name);
        shutdownCallback.onSuccess((Object)None.none());
    }

    private void doCreate() {
        LOG.debug("{}: creating a new item", (Object)this._name);
        this._rateLimiter.submit(callback -> this._lifecycle.create(new Callback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(T item) {
                LOG.debug("{}: item creation succeeded", (Object)AsyncSharedPoolImpl.this._name);
                ArrayList waiters = new ArrayList();
                Object object = AsyncSharedPoolImpl.this._lock;
                synchronized (object) {
                    AsyncSharedPoolImpl.this._statsTracker.incrementCreated();
                    int size = AsyncSharedPoolImpl.this._waiters.size();
                    AsyncSharedPoolImpl.this._checkedOut = AsyncSharedPoolImpl.this._checkedOut + size;
                    AsyncSharedPoolImpl.this._statsTracker.sampleMaxCheckedOut();
                    IntStream.range(0, size).forEach(i -> waiters.add(AsyncSharedPoolImpl.this._waiters.poll()));
                    AsyncSharedPoolImpl.this._item.set(item);
                    AsyncSharedPoolImpl.this._statsTracker.sampleMaxPoolSize();
                    AsyncSharedPoolImpl.this._isCreateInProgress = false;
                }
                waiters.stream().forEach(waiter -> {
                    try {
                        waiter.onSuccess(item);
                    }
                    catch (Exception ex) {
                        LOG.error("Encountered error while invoking success waiter callback", (Throwable)ex);
                    }
                });
                callback.onDone();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable e) {
                Collection waiters;
                LOG.error("{}: item creation failed", (Object)AsyncSharedPoolImpl.this._name, (Object)e);
                AsyncSharedPoolImpl.this._rateLimiter.incrementPeriod();
                Collection<RateLimiter.Task> tasks = AsyncSharedPoolImpl.this._rateLimiter.cancelPendingTasks();
                Object object = AsyncSharedPoolImpl.this._lock;
                synchronized (object) {
                    waiters = AsyncSharedPoolImpl.this.cancelWaiters();
                    AsyncSharedPoolImpl.this._statsTracker.incrementCreateErrors();
                    AsyncSharedPoolImpl.this._isCreateInProgress = false;
                }
                waiters.stream().forEach(waiter -> {
                    try {
                        waiter.onError(e);
                    }
                    catch (Exception ex) {
                        LOG.error("Encountered error while invoking error waiter callback", (Throwable)ex);
                    }
                });
                callback.onDone();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doDispose(T item) {
        if (item == null) {
            LOG.error("{}: item is null so nothing to dispose", (Object)this._name);
            return false;
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._item.get() != null && this._item.get() == item) {
                this._disposedItems.put(this._item.get(), this._checkedOut);
                this._item.reset();
                this._checkedOut = 0;
            }
            if (!this._disposedItems.containsKey(item)) {
                throw new IllegalArgumentException("Disposing a previously destroyed item or an item that was not checked out from the pool");
            }
            int count = this._disposedItems.get(item) - 1;
            if (count == 0) {
                this._disposedItems.remove(item);
                if (this._destroyInProgress.contains(item)) {
                    LOG.debug("{}: item {} destroy is in progress", (Object)this._name, item);
                    return false;
                }
                this._destroyInProgress.add(item);
                return true;
            }
            this._disposedItems.put(item, count);
            return false;
        }
    }

    private void doDestroy(final T item, boolean bad, final SimpleCallback callback) {
        LOG.debug("{}: destroying an item {}", (Object)this._name, item);
        if (bad) {
            this._statsTracker.incrementBadDestroyed();
        }
        this._lifecycle.destroy(item, bad, new Callback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(T item2) {
                try {
                    Object object = AsyncSharedPoolImpl.this._lock;
                    synchronized (object) {
                        AsyncSharedPoolImpl.this._statsTracker.incrementDestroyed();
                        AsyncSharedPoolImpl.this._destroyInProgress.remove(item2);
                    }
                }
                finally {
                    callback.onDone();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable e) {
                LOG.error("{}: failed to destroy an item", (Object)AsyncSharedPoolImpl.this._name, (Object)e);
                try {
                    Object object = AsyncSharedPoolImpl.this._lock;
                    synchronized (object) {
                        AsyncSharedPoolImpl.this._statsTracker.incrementDestroyErrors();
                        AsyncSharedPoolImpl.this._destroyInProgress.remove(item);
                    }
                }
                finally {
                    callback.onDone();
                }
            }
        });
    }

    private class TimeTrackingCallback
    implements Callback<T> {
        private final long _startTime;
        private final Callback<T> _callback;

        public TimeTrackingCallback(Callback<T> callback) {
            this._callback = callback;
            this._startTime = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable e) {
            Object object = AsyncSharedPoolImpl.this._lock;
            synchronized (object) {
                AsyncSharedPoolImpl.this._statsTracker.trackWaitTime(System.currentTimeMillis() - this._startTime);
            }
            this._callback.onError(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(T item) {
            Object object = AsyncSharedPoolImpl.this._lock;
            synchronized (object) {
                AsyncSharedPoolImpl.this._statsTracker.trackWaitTime(System.currentTimeMillis() - this._startTime);
            }
            this._callback.onSuccess(item);
        }
    }

    private final class TimedObject<T> {
        private T _item = null;
        private long _timestamp = 0L;

        private TimedObject() {
        }

        public final T get() {
            return this._item;
        }

        public final long timestamp() {
            return this._timestamp;
        }

        public void set(T item) {
            this._item = item;
            this._timestamp = System.currentTimeMillis();
        }

        public void renew() {
            this._timestamp = System.currentTimeMillis();
        }

        public final void reset() {
            this._item = null;
            this._timestamp = 0L;
        }

        public boolean expired() {
            return this._timestamp < System.currentTimeMillis() - AsyncSharedPoolImpl.this._timeoutMills;
        }
    }

    private static enum State {
        NOT_YET_STARTED,
        RUNNING,
        SHUTTING_DOWN,
        STOPPED;

    }
}

