/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import kafka.serializer.Encoder;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.config.ConfigException;

public class KafkaAvroEncoder
extends AbstractKafkaAvroSerializer
implements Encoder<Object> {
    public KafkaAvroEncoder(SchemaRegistryClient schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    public KafkaAvroEncoder(VerifiableProperties props) {
        if (props == null) {
            throw new ConfigException("Missing schema registry url!");
        }
        String url = props.getProperty("schema.registry.url");
        if (url == null) {
            throw new ConfigException("Missing schema registry url!");
        }
        int maxSchemaObject = props.getInt("max.schemas.per.subject", 1000);
        this.schemaRegistry = new CachedSchemaRegistryClient(url, maxSchemaObject);
    }

    public byte[] toBytes(Object object) {
        return this.serializeImpl(KafkaAvroEncoder.getOldSubjectName(object), object);
    }
}

